export default [
  {
    path: '/',
    redirect: '/error'
  },
  {
    path: '/demo',
    alias: ['/demo-page'],
    name: 'demo-page',
    back: false,
    meta: {
      title: 'DEMO',
      has: {
        header: true,
        footer: true
      }
    },
    component: () => import('../views/demo')
  },
  {
    path: '/error',
    name: 'error',
    meta: {
      title: '出错了'
    },
    component: () => import('../components/error')
  },
  {
    path: '*',
    name: 'notFound',
    meta: {
      title: '找不到页面'
    },
    component: () => import('../components/error/NotFound')
  }
];
