module.exports = [
  {
    path: '/groupBuy/skuInfo',
    name: 'groupBuySkuInfo',
    component: () => import('../views/goodsDetail/index.vue'),
    meta: { title: '组团0元购' }
  },
  {
    path: '/groupBuy/skuInfoSmallPic',
    name: 'groupBuySkuInfoSmallPic',
    component: () => import('../views/goodsDetail/smallPic.vue'),
    meta: { title: '组团0元购' }
  },
  {
    path: '/groupBuy/list',
    name: 'groupBuyList',
    component: () => import('../views/goodsList/index.vue'),
    meta: { title: '0元购大牌' }
  },
  {
    path: '/orderList/:status',
    name: 'orderList',
    meta: {
      title: '我的拼团'
    },
    component: () => import('../views/orderList/index.vue')
  },
  {
    path: '/createOrder',
    name: 'createOrder',
    meta: {
      title: '确认订单',
      keepAlive: true // 需要缓存
    },
    component: () => import('../views/order/createOrder')
  },
  {
    path: '/pay',
    name: 'pay',
    meta: {
      title: '收银台'
    },
    component: () => import('../views/pay')
  },
  {
    path: '/payFail',
    name: 'payFail',
    meta: {
      title: '支付失败'
    },
    component: () => import('../views/pay/payResult')
  },
  {
    path: '/paySuccess',
    name: 'paySuccess',
    meta: {
      title: '支付成功',
      success: true
    },
    component: () => import('../views/pay/payResult')
  },
  {
    path: '/payWaiting',
    name: 'payWaiting',
    meta: {
      title: '支付中',
      success: true
    },
    component: () => import('../views/pay/payWaiting')
  },

  {
    path: '/address',
    name: 'address',
    meta: {
      title: '我的地址'
    },
    component: () => import('../views/address/address')
  },
  {
    path: '/addressManage',
    name: 'addressManage',
    meta: {
      title: '新增地址'
    },
    component: () => import('../views/address/addressManage')
  }
];
