import * as types from './type';
const state = {
  header: true,
  title: '支付中心',
  loading: false,
  meta: {},
  keepAliveMap: [],
  showMiniappGuide: false
};

// getters
const getters = {};

// actions
const actions = {
  change_header({ commit }, header) {
    commit(types.CHANGE_HEADER, header);
  },
  change_title({ commit }, title) {
    commit(types.CHANGE_TITLE, title);
  },
  change_meta({ commit }, meta) {
    commit(types.CHANGE_META, meta);
  },
  change_loading({ commit }, loading) {
    commit(types.CHANGE_LOADING, loading);
  },
  add_keep_alive({ commit }, name) {
    commit(types.ADD_KEEP_ALIVE, name);
  },
  change_show_mini_app_guide({ commit }, obj) {
    commit(types.CHANGE_SHOW_MINI_APP_GUIDE, obj);
  }
};

// mutations
const mutations = {
  [types.CHANGE_HEADER](state, header) {
    if (header !== undefined) {
      state.header = header;
    }
  },
  [types.CHANGE_LOADING](state, loading) {
    state.loading = loading;
  },
  [types.CHANGE_TITLE](state, title) {
    if (title) {
      state.title = title;
    }
    document.title = state.title;
  },
  [types.CHANGE_META](state, meta) {
    for (let i in meta) {
      state.meta[i] = meta[i];
    }
  },
  [types.ADD_KEEP_ALIVE](state, name) {
    const keepAliveMap = state.keepAliveMap;
    keepAliveMap.push(name);
    state.keepAliveMap = [...new Set(keepAliveMap)];
  },
  [types.DEL_KEEP_ALIVE](state, name) {
    state.keepAliveMap.splice(
      state.keepAliveMap.findIndex(item => item === name),
      1
    );
  },
  [types.CLEAR_KEEP_ALIVE](state) {
    state.keepAliveMap = [];
  },
  [types.CHANGE_SHOW_MINI_APP_GUIDE](state, { bool, pointer }) {
    state.showMiniappGuide = bool;
    if (bool) {
      // 如果非app webview并且非小程序webview，直接拦截提示，到小程序操作
      pointer.$dialog({
        message: '请在微信小程序中参与此活动哦~',
        showCancelButton: false,
        confirmButtonText: '打开微信小程序',
        onConfirm: () => {
          // todo 跳转到小程序
        }
      });
    }
  }
};

export default {
  state,
  getters,
  actions,
  mutations
};
