import config from '@/config';
import http from '@/service/httpDecorator';
const { talosHost } = config;

export default {
  // 查询商品sku详情
  detailInfo: params => {
    return http.post(`${talosHost}/api/kdsp/activity/activity-goods-special/detail`, { ...params });
  },
  // 详情图片
  getDetailPic: url => {
    return http.get(url, { strategy: 'default', hideLoading: 1, skip: 1, hideToast: 1 });
  },
  // 商品详情地址列表
  addrList(data) {
    return http.get(`${talosHost}/api/kdsp/addr/receiver/list`, data, {
      hideLoading: true
    });
  },

  // 查询活动模板列表-根据活动id
  getTemplateList(activityId) {
    return http.get(
      `http://yapi.quantgroups.com/mock/351/api/kdsp/activity/activity-goods-special/template-list`,
      {
        // return http.get(`${talosHost}/api/kdsp/activity/activity-goods-special/template-list`, {
        params: { activityId }
      }
    );
  },
  // 入口活动列表
  getGoodsList(params) {
    return http.get(
      `http://yapi.quantgroups.com/mock/351/api/kdsp/activity/activity-goods-special/goods-list`,
      {
        // return http.get(`${talosHost}/api/kdsp/activity/activity-goods-special/goods-list`, {
        params
      }
    );
  },
  getGroupAvator(data) {
    return http.get(`http://yapi.quantgroups.com/mock/479/goods/getAvator`, data, {
      hideLoading: true
    });
  },
  getWxConfig(url = window.location.href.split('#')[0]) {
    return http.post(`${talosHost}/api/kdsp/wx/mp/getJsapiSign`, {
      url: url,
      appId: 'wx2f44c7fe7b08458d'
    });
  },
  getScheme(data) {
    return http.get(`${talosHost}/api/kdsp/ka/info/getShareMiniUrl`, data, {
      hideLoading: true
    });
  }
};
