/**
 * Created by jialiu on 17/1/11.
 */
import store from '../store';
import { isWechat, isApp } from './validation.service';
import Cookies from './cookieStorage.service';
import localStorage from './localStorage.service';
//formXcxPage:标识是从小程序跳转过来的;
const localStorageParams = ['creditToken', 'vccToken', 'vccChannel', 'formXcxPage'];
const cookiesParams = ['h'];

export default {
  // token校验，整个流程都是登陆后的
  init: router => {
    router.beforeEach((to, from, next) => {
      // 所有自定义路由字段在此处理
      const { meta } = to;
      isWechat && localStorage.set('vccChannel', '159913');
      meta?.has?.header && store.commit('CHANGE_HEADER', meta.has.header); // 改变header
      localStorageParams.forEach(item => {
        to.query[item] && localStorage.set(item, to.query[item]);
      });
      cookiesParams.forEach(item => {
        to.query[item] && Cookies.set(item, to.query[item]);
      });

      (isWechat || isApp || Cookies.get('h') === '0') && store.commit('CHANGE_HEADER', false); // 改变header
      document.body.className = store.state.pay.header ? 'has-header' : '';
      store.commit('CHANGE_TITLE', meta?.title); // 改变title

      next();
    });
  }
};
