import cookies from '@/service/cookieStorage.service';
export const goUrlExtends = {
  methods: {
    goHome(payStatus) {
      // 商城地址
      if (payStatus) {
        this.$track?.registeredEvents('h5_RechargeResultPageClick', {
          pay_status: payStatus,
          buttons_name: '返回首页'
        });
      }
      setTimeout(() => {
        this.$router.replace({ name: 'home' });
      }, 500);
    },
    goOrderList(payStatus) {
      if (payStatus) {
        this.$track?.registeredEvents('h5_RechargeResultPageClick', {
          pay_status: payStatus,
          buttons_name: '查看订单'
        });
      }
      setTimeout(() => {
        this.$router.replace({ name: 'orderList', params: { state: 0 } });
      }, 500);
    },
    goOrderDetail() {
      const orderNo = cookies.get('orderNo')?.orderNo;
      this.$router.push({
        name: 'orderDetail',
        query: { orderNo }
      });
    }
  }
};
