import config from '@/config';
import http from '@/service/httpDecorator';
const { talosHost } = config;

export default {
  // 查询商品sku详情
  detailInfo: params => {
    return http.get(`${talosHost}/api/kdsp/sku-info/detail/query`, { params });
  },
  // 详情图片
  getDetailPic: url => {
    return http.get(url, { strategy: 'default', hideLoading: 1, skip: 1, hideToast: 1 });
  },
  // 商品详情地址列表
  addrList(data) {
    return http.get(`${talosHost}/api/kdsp/addr/receiver/list`, data, {
      hideLoading: true
    });
  },
  // 入口活动列表
  getGroupList(data) {
    return http.get(`http://yapi.quantgroups.com/mock/479/goods/group-list`, data, {
      hideLoading: true
    });
  },
  getGroupAvator(data) {
    return http.get(`http://yapi.quantgroups.com/mock/479/goods/getAvator`, data, {
      hideLoading: true
    });
  }
};
