import * as types from './type';

const state = {
  header: true,
  title: '支付中心',
  loading: false,
  meta: {},
  keepAliveMap: []
};

// getters
const getters = {};

// actions
const actions = {
  change_header({ commit }, header) {
    commit(types.CHANGE_HEADER, header);
  },
  change_title({ commit }, title) {
    commit(types.CHANGE_TITLE, title);
  },
  change_meta({ commit }, meta) {
    commit(types.CHANGE_META, meta);
  },
  change_loading({ commit }, loading) {
    commit(types.CHANGE_LOADING, loading);
  },
  add_keep_alive({ commit }, name) {
    commit(types.ADD_KEEP_ALIVE, name);
  }
};

// mutations
const mutations = {
  [types.CHANGE_HEADER](state, header) {
    if (header !== undefined) {
      state.header = header;
    }
  },
  [types.CHANGE_LOADING](state, loading) {
    state.loading = loading;
  },
  [types.CHANGE_TITLE](state, title) {
    if (title) {
      state.title = title;
    }
    document.title = state.title;
  },
  [types.CHANGE_META](state, meta) {
    for (let i in meta) {
      state.meta[i] = meta[i];
    }
  },
  [types.ADD_KEEP_ALIVE](state, name) {
    const keepAliveMap = state.keepAliveMap;
    keepAliveMap.push(name);
    state.keepAliveMap = [...new Set(keepAliveMap)];
  },
  [types.DEL_KEEP_ALIVE](state, name) {
    state.keepAliveMap.splice(
      state.keepAliveMap.findIndex(item => item === name),
      1
    );
  },
  [types.CLEAR_KEEP_ALIVE](state) {
    state.keepAliveMap = [];
  }
};

export default {
  state,
  getters,
  actions,
  mutations
};
