import request from '@/service/httpDecorator';
import config from '@/config';
import { saDeviceId } from '@/service/sa.service';
const { talosHost } = config;

const queryPayStatus = function(data) {
  return request.post(`${talosHost}/open/checkout/pay_status/query`, data);
};

const getGoodsList = async function(data) {
  const scDeviceId = await saDeviceId();
  return request.get(`${talosHost}/vcc/xyqb/recommend/goods-list`, {
    params: data,
    hideLoading: true,
    customHeader: {
      scDeviceId
    }
  });
};

const getCouponList = function(params) {
  return request.get(`${talosHost}/api/kdsp/appconfig/pay-succ-page/guide-stream`, { params });
};
// 获取用户手机号
const getPhoneNumber = function() {
  return request.get(`${talosHost}/api/kdsp/user/phone`);
};
export {
  getGoodsList,
  getCouponList,
  queryPayStatus,
  getPhoneNumber
};
