import Bridge from '@qg/js-bridge';
import MpBridge from '@/service/mp';
import { isWxMp, isApp } from '@/service/validation.service';
import localStorage from '@/service/localStorage.service';
import cookies from '@/service/cookieStorage.service';
export default {
  data() {
    return {
      nativeBridge: null
    };
  },
  methods: {
    getToken() {
      const _this = this;
      window.xyqbNativeEvent = function(res) {
        const json = typeof res === 'string' ? JSON.parse(res) : res;
        if (json.event === 'getTokenSuccess') {
          const appData = json.data || {};
          if (appData && appData.token) {
            localStorage.set('vccToken', appData.token);
            cookies.set('vccToken', appData.token);
            // window.sessionStorage.setItem('vccToken', appData.token);
            _this.$nextTick(() => {
              window.location.reload();
            });
          }
        }
      };
      this.nativeBridge.getToken();
    },
    checkLogin() {
      const vccToken = localStorage.get('vccToken');
      this.$toast(vccToken);
      const needLogin = vccToken ? false : true;
      if (needLogin) {
        if (isApp) this.nativeBridge = new Bridge();
        else if (isWxMp) this.nativeBridge = new MpBridge();
        this.$dialog({
          message: '参与拼团活动需要您先进行登录哦~',
          title: '',
          showCancelButton: false,
          confirmButtonText: '登录',
          onConfirm: () => {
            if (isWxMp) {
              this.nativeBridge.getToken({ from: 'groupbuy' });
            } else if (isApp) {
              // native调用getToken
              this.getToken();
            } else {
              this.$dialog({
                message: '请在App或小程序中参与活动~',
                title: '',
                showCancelButton: false,
                confirmButtonText: '我知道了'
              });
            }
          }
        });
      }
    }
  }
};
