import config from '@/config';
import http from '@/service/httpDecorator';
const { talosHost } = config;

export default {
  saveAddress(data) {
    return http.post(`${talosHost}/api/kdsp/addr/receiver/add_edit`, data);
  },
  getAddressList() {
    return http.get(`${talosHost}/api/kdsp/addr/receiver/list`);
  },
  deleteAddress(addrReceiverId) {
    return http.post(`${talosHost}/api/kdsp/addr/receiver/delete`, {
      addrReceiverId
    });
  },
  // 地址级联查询
  zoneList: params => {
    return http.get(`${talosHost}/api/kdsp/addr/query?addrId=${params}`);
  }
};
