import user from '@/api/user.api';
import store from '@/store';
import { getQueryString, parseSearch } from './utils.service';
import localStorage from './localStorage.service';
// eslint-disable-next-line space-before-function-paren
export const getUserInfo = async () => {
  const [data] = await user.getUserInfo();
  const { userInfo } = data || {};
  store.commit('CHANGE_LOGIN', userInfo);
  return userInfo;
};

export const getToKen = () => {
  const vccToken = getQueryString('vccToken');
  const oldToken = localStorage.get('vccToken') || '';
  if (!oldToken) {
    store.commit('CHANGE_TOKEN', vccToken);
  }
};

export function getVccChannel(channelKey = 'vccChannel') {
  if (channelKey === 'sonVccChannel') {
    return localStorage.get(channelKey) || parseSearch(window.location.href)[channelKey] || '';
  }
  return localStorage.get(channelKey) || parseSearch(window.location.href)[channelKey] || '';
}
