import Bridge from '@qg/js-bridge';
import MpBridge from '@/service/mp';
import { isWxMp, isApp } from '@/service/validation.service';
import localStorage from '@/service/localStorage.service';
export default {
  data() {
    return {
      nativeBridge: null
    };
  },
  methods: {
    getToken() {
      const that = this;
      window.xyqbNativeEvent = function(res) {
        const json = typeof res === 'string' ? JSON.parse(res) : res;
        if (json.event === 'getTokenSuccess') {
          const appData = json.data || {};
          if (appData && appData.token) {
            localStorage.get('vccToken', appData.token);
            that.$nextTick(() => {
              window.location.reload();
            });
          }
        }
      };
      this.nativeBridge.getToken();
    },
    checkLogin() {
      const vccToken = localStorage.get('vccToken');
      alert(vccToken);
      const needLogin = vccToken ? false : true;
      // alert(vccToken);
      // alert(needLogin);
      if (needLogin) {
        if (isApp) this.nativeBridge = new Bridge();
        else if (isWxMp) this.nativeBridge = new MpBridge();
        this.$dialog({
          message: '参与拼团活动需要您先进行登录哦~',
          title: '',
          showCancelButton: false,
          confirmButtonText: '登录',
          onConfirm: () => {
            if (isWxMp) {
              this.nativeBridge.getToken();
            } else if (isApp) {
              // native调用getToken
              this.getToken();
            } else {
              this.$dialog({
                message: '请在App或小程序中参与活动~',
                title: '',
                showCancelButton: false,
                confirmButtonText: '我知道了'
              });
            }
          }
        });
      }
      return needLogin;
    }
  }
};
