import axios from '../services/http.service'
import {
  sapi
} from '../config'
import qs from 'qs'
let comapi = '/heimdallr-config'
// 获取服务列表
export function getservicelist () {
  return axios.get(`/heimdallr/service/list`)
}
// 获取文字说明
export function getkey (key) {
  return axios.get(`/heimdallr/get-key-explain/${key}`)
}
// 获取配置列表
export function getconfigurelist (data) {
  return axios.get(`/heimdallr/config/service/${data.key}/${data.service_name}`)
}
// 发布
export function postconfigurelist (data, params) {
  return axios.post(`/heimdallr/config/service/${data.key}/${data.service_name}`, params, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 获取版本
export function getVersionnumber (data) {
  return axios.get(`/heimdallr/config-version/service/${data.key}/${data.service_name}/list`)
}
// 回滚版本
export function rollbacknum (data) {
  return axios.get(`/heimdallr/config-version/service/${data.key}/${data.service_name}/set/${data.version}`)
}
// 获取节点列表
export function getnodelist (data) {
  return axios.get(`/heimdallr/node/list/${data.service_name}`)
}
// 获取节点配置
export function getnodeconfig (data) {
  return axios.get(`/heimdallr/config/node/${data.service_name}/${data.node_id}`)
}
// 设置节点配置
export function nodeconfig (data, weight) {
  return axios.post(`/heimdallr/config/node/${data.service_name}/${data.node_id}`, weight, {headers: {
    'Content-Type': 'application/json'
  }})
}
