import {Component, Vue} from 'vue-property-decorator';
// import schameConfig from '@qg/cherry-ui/src/button/schame.js';
import components from '@qg/cherry-ui/src/index.js';
import { kebabCase } from 'lodash';

@Component({ name: 'DynamicConponent' })
export default class DynamicConponent extends Vue {
  eleConfig = [
    {
      eleName: 'cr-button',
      config: [
        {
            key: 'color',
            name: '按钮颜色',
          type: 'ColorPicker'
        },
        {
            key: 'text',
            name: '按钮文案',
            type: 'Input'
        }
      ],
      value: {
        color: '#07c160',
        text: '按钮1'
      }
    },
    {
      eleName: 'cr-field',
      config: [
        {
            key: 'placeholder',
            name: '提示信息',
          type: 'Input'
        },
        {
            key: 'label',
            name: 'label文案',
            type: 'Input'
        }
      ],
      value: {
        placeholder: '请输入',
        label: 'label'
      }
    }
  ];

  dragstart(event, eleName) {

    this.$emit('dragstart');
    if (eleName === 'freedom-container') {
      event.dataTransfer.setData('text', JSON.stringify({
        name: eleName,
        point: {x: 0, y: 2, w: 12, h: 5, i: '2'},
        child: [],
      }));
    } else {
      const props = this.getProps(eleName);
      const eleConfig = this.eleConfig.find(config => config.eleName === eleName);
      event.dataTransfer.setData('text', JSON.stringify({
          name: eleName,
          point: {x: 0, y: 0, w: 12, h: 1, i: '0'},
          schame: eleConfig.config,
          props: {...props, ...eleConfig.value},
          commonStyle: {
            position: 'absolute',
            top: 5,
            left: 5
          }
        }));
    }
    console.log('getData', event.dataTransfer.getData('text'));
    event.dataTransfer.effectAllowed = 'copyMove';
  }

  dragend() {
    this.$emit('dragend');
    console.log('dragend');
  }

  getProps(eleName) {
    const props = {};
    for (const key of Object.keys(components)) {
      const component = components[key];
      if (kebabCase(component.name) === eleName && component.props) {
        for (const prop of Object.keys(component.props)) {
          props[prop] = ['Object', 'Array'].includes(component.props[prop].type.name) ? component.props[prop].default && component.props[prop].default() : component.props[prop].default;
        }
      }
    }

    console.log(props);
    return props;
  }
}