import { Vue, Component } from 'vue-property-decorator';
import DynamicConponent from '@editor/component/DynamicComponent/index.vue';
import VueGridLayout from 'vue-grid-layout';
import eleConfig from '@editor/utils/config';

import {
  Getter,
  Action
} from 'vuex-class';

@Component({components: { DynamicConponent, GridLayout: VueGridLayout.GridLayout,
           GridItem: VueGridLayout.GridItem }, name: 'DashBoard')
export default class DashBoard extends Vue {
  activeName: string = '1';
  isCollapsed: boolean = false;
  isDrag: boolean = false;
  pageData = {
    elements: [
      {
        name: 'cr-button',
        point: {x: 0, y: 0, w: 12, h: 1, i: '0'},
      },
      {
        name: 'cr-field',
        point: {x: 0, y: 1, w: 12, h: 1, i: '1'},
      },
    ]
  };

  get layout() {
      return this.pageData.elements.map(v => v.point);
  }

  // 选择组件库
  selectComponent(val: string) {
    this.activeName = val;
  }

  toggle(val) {
    console.log(val);
    this.isCollapsed = val;
  }

  dragenter() {
    console.log('dragenter');
    this.isDrag = true;
  }

  dragleave() {
    console.log('dragleave');
    this.isDrag = false;
  }

  drops(event) {
    this.isDrag = false;
    this.isCollapsed = false;
    const data = JSON.parse(event.dataTransfer.getData('text'));
    event.dataTransfer.clearData();
    console.log({...data, i: this.pageData.elements.length});
    this.pageData.elements.push({...data, point: { ...data.point, i: this.pageData.elements.length}});
  }
}