'use strict';
const path = require('path');
const resolve = filepath => path.resolve(__dirname, filepath);
module.exports = {
  entry: {
    'admin/login': 'app/web/page/admin/login/login.vue',
    'admin/home': 'app/web/page/admin/home/index.ts',
    'editor': 'app/web/page/editor/index.ts',
  },
  resolve: {
    alias:{
      '@asset': resolve('app/web/asset'),
      '@framework': resolve('app/web/framework'),
      '@component': resolve('app/web/component'),
      '@store': resolve('app/web/page/store'),    
      '@router': resolve('app/web/page/admin/home/router'),        
      '@view': resolve('app/web/page/admin/home/view'),
      '@editor': resolve('app/web/page/editor')
    }
  },
  nodeExternals: {
    whitelist: [ moduleName => { 
      if (moduleName.includes('cherry-ui')) {
        console.log(moduleName);
      }
      return /cherry-ui/.test(moduleName);
    }] 
  },
  module:{
    rules:[
      { babel: {
          include: [resolve('app/web'), resolve('node_modules/@qg/cherry-ui')],
          exclude: []
        } 
      },
      {
        vue: {
          include: [resolve('app/web'),resolve('node_modules/@qg/cherry-ui')],
          exclude: [],
        }
      },
      { ts: {
          exclude: []
        } 
      },
      {  less: true },
      { tslint: { options: { fix: true } } }
    ]
  },
  plugins: [
    {
      copy: [{
        from: 'app/web/asset',
        to: 'asset'
      }]
    }
  ],
  customize(webpackConfig){ 
   // 此外 webpackConfig 为原生生成的 webpack config，可以进行自定义处理
   return webpackConfig;
  }
};