import { Vue, Component, Watch } from 'vue-property-decorator';
import DynamicConponent from '@editor/component/DynamicComponent/index.vue';
import VueGridLayout from 'vue-grid-layout';
import eleConfig from '@editor/utils/config';
import FreedomContainer from '../../component/FreedomContainer/index.vue';
import DynamicForm from '../../component/DynamicForm/index.vue';
import schameConfig from '@qg/cherry-ui/src/button/schame.js';
import components from '@qg/cherry-ui/src/index.js';
import { kebabCase } from 'lodash';

import {
  Getter,
  Action,
  State
} from 'vuex-class';

@Component({components: { DynamicConponent, FreedomContainer, DynamicForm, GridLayout: VueGridLayout.GridLayout,
           GridItem: VueGridLayout.GridItem }, name: 'DashBoard'})
export default class DashBoard extends Vue {
  @Action('addPageDate') addPageDate;
  @Action('updatePageDate') updatePageDate;
  @Getter('pageId') pageId;

  activeName: string = '1';
  isCollapsed: boolean = false;
  isDragIn: boolean = false;
  isDraging: boolean = false;
  curEleIndex: number | null = null;
  curChildIndex: number | null = null;
  // todo:
  // 1. grid拖拽进去后的顺序
  // 2. init height

  pageData = {
    elements: [
      // {
      //   name: 'cr-button',
      //   point: {x: 0, y: 0, w: 12, h: 1, i: '0'},
      //   schame: schameConfig.config,
      //   props: {...this.getProps('cr-button'), ...schameConfig.value},
      //   commonStyle: {
      //     position: 'absolute',
      //     top: 5,
      //     left: 5
      //   }
      // },
      // {
      //   name: 'cr-field',
      //   point: {x: 0, y: 1, w: 12, h: 1, i: '1'},
      // },
      // {
      //   name: 'freedom-container',
      //   point: {x: 0, y: 2, w: 12, h: 5, i: '2'},
      //   child: [],
      // },
    ]
  };

  get layout() {
      return this.pageData.elements.map(v => v.point);
  }

  get curElement() {
    let element = {};
    if (this.curEleIndex !== null) {
      if (this.curChildIndex !== null) {
        element = this.pageData.elements[this.curEleIndex].child[this.curChildIndex];
      } else {
        element = this.pageData.elements[this.curEleIndex];
      }
    }
    return element;
  }

  // 选择组件库
  selectMaterial(val: string) {
    this.activeName = val;
  }

  async preview() {
    this.pageData.elements.sort((a, b) => a.point.y - b.point.y);
    if (this.pageId) {
      await this.updatePageDate({id: this.pageId, pageData: this.pageData});
    } else {
      await this.addPageDate(this.pageData);
    }
    window.open(`http://localhost:7001/activity/${this.pageId}`);
  }

  handleElementClick(curEleIndex, curChildIndex) {
    console.log(curEleIndex, curChildIndex);
    this.toggle(false);
    this.curEleIndex = curEleIndex;
    this.curChildIndex = curChildIndex;
  }

  toggle(val) {
    this.isCollapsed = val;
  }

  dragstart() {
    this.isDraging = true;
  }

  dragend() {
    this.isDraging = false;
  }

  dragenter() {
    console.log('dragenter');
    this.isDragIn = true;
  }

  dragleave() {
    console.log('dragleave');
    this.isDragIn = false;
  }

  dragover(event) {
    if (event.target.classList.contains('freedom')) {
      event.dataTransfer.dropEffect = 'move';
    } else {
      event.dataTransfer.dropEffect = 'copy';
    }
  }

  resize(containerIndex, childIndex, style) {
    this.pageData.elements[containerIndex].child[childIndex].commonStyle = style;
  }

  modProps(props) {
    console.log('modProps');
    if (this.curEleIndex !== null) {
      if (this.curChildIndex !== null) {
        this.pageData.elements[this.curEleIndex].child[this.curChildIndex].props = { ...this.pageData.elements[this.curEleIndex].child[this.curChildIndex].props, ...props};
        console.log(this.pageData.elements[this.curEleIndex].child[this.curChildIndex].props);
      } else {
        this.pageData.elements[this.curEleIndex].props = { ...this.pageData.elements[this.curEleIndex].props, ...props};
      }
    }
  }

  drops(event) {
    console.log(event.target);
    this.isDragIn = false;
    this.isCollapsed = false;
    const data = JSON.parse(event.dataTransfer.getData('text'));
    event.dataTransfer.clearData();
    console.log({...data, i: this.pageData.elements.length}, this.pageData.elements[event.target.dataset.index]);
    if (event.target.classList.contains('freedom')) {
      this.pageData.elements[event.target.dataset.index].child.push(data);
    } else {
      this.pageData.elements.push({...data, point: { ...data.point, i: this.pageData.elements.length}});
    }
  }

  getProps(eleName) {
    const props = {};
    for (const key of Object.keys(components)) {
      const component = components[key];
      if (kebabCase(component.name) === eleName && component.props) {
        console.log(key, component.props);
        for (const prop of Object.keys(component.props)) {
          props[prop] = [Object, Array].includes(component.props[prop].type) ? component.props[prop].default() : component.props[prop].default;
        }
      }
    }

    console.log(props);
    return props;
  }
}