import {Component, Vue, Prop} from 'vue-property-decorator';
import _ from 'lodash';

@Component({ name: 'FreedomContainer' })
export default class FreedomContainer extends Vue {
  @Prop({type: Object, default: () => ({ child: [] })}) childItem;
  @Prop({type: Number, default: 0}) containerIndex;

  mousedown(childIndex, event) {
    console.log(childIndex, event);
    const childItem = _.cloneDeep(this.childItem);
    const { top: startTop, left: startLeft } = childItem.child[childIndex].commonStyle;
    const { clientY, clientX } = event;

    const move = moveEvent => {
      moveEvent.stopPropagation();
      moveEvent.preventDefault();

      const top = moveEvent.clientY - clientY + startTop;
      const left = moveEvent.clientX - clientX + startLeft;

      this.$emit('resize', this.containerIndex, childIndex, {...childItem.child[childIndex].commonStyle, top, left});
    };
    const up = () => {
      document.removeEventListener('mousemove', move, true);
      document.removeEventListener('mouseup', up, true);
    };
    document.addEventListener('mousemove', move, true);
    document.addEventListener('mouseup', up, true);
  }

   transformStyle(styleObj) {
    const style = {};
    for (const key of Object.keys(styleObj)) {
      style[key] = typeof styleObj[key] !== 'string' ? `${styleObj[key]}px` : styleObj[key];
      if (key === 'backgroundImage') {
        style.backgroundImage = `url(${style.backgroundImage})`;
      }
    }
    return style;
  }

  handleElementClick(curEleIndex, curChildIndex) {
    this.$emit('handleElementClick', curEleIndex, curChildIndex);
  }
}