import {Component, Vue, Prop, Watch} from 'vue-property-decorator';
import { reduce } from 'lodash';

@Component({ name: 'DynamicForm' })
export default class DynamicForm extends Vue {
  @Prop({type: Object, default: () => ({ schame: { config: [], value: [] } })}) curElement;

  form: object = {};

  @Watch('curElement', { immediate: true, deep: true })
  onElementChange(newVal) {
    this.form = reduce(newVal.schame, (obj, param) => {
      obj[param.key] = newVal.props[param.key];
      return obj;
    }, {});
  }

  change(val) {
   this.$emit('modProps', this.form);
  }
}