import { Controller, Context } from 'egg';
import { deserialize } from '@hubcarl/json-typescript-mapper';

export default class EditorController extends Controller {

  public async home(ctx: Context) {
    await ctx.renderClient('editor.js', {});
  }

  public async save(ctx: Context) {
    const pageData = ctx.request.body;
    ctx.body =  await ctx.model.PageInfo.create({page: JSON.stringify(pageData)});
  }

  public async update(ctx: Context) {
    const pageInfo = ctx.request.body;
    ctx.body = await ctx.model.PageInfo.update(pageInfo, {where: { id: +pageInfo.pageId }});
  }

  public async get(ctx: Context) {
    console.log('pageId', ctx.params.pageId);
    ctx.body = await ctx.model.PageInfo.findOne({where: { id: +ctx.params.pageId }});
  }
}