'use strict';

// const mockMails = `vn1sahsubs@163.com----anncprv
// hwm32fxuix@163.com----qfagkir
// df2srdvgeex@163.com----wvl0ku6
// heidrck9@163.com----a5isadj
// tfj62n1i@163.com----vko8gst
// c5gst97u2o@163.com----m7yzf6s
// k3a5n0l7n@163.com----c50k8vc
// r4re5vzp@163.com----o7hguhx
// songshi21698@163.com----n44n3hf0
// tuopanzi16403@163.com----prdv49tn6
// hongluxuan93@126.com----f5nwe0ody
// xingyu2288070@126.com----btscv4gr
// baichenqiao9703@126.com----e86gh8mc
// guluzhuo09@126.com----vlaj02fv
// hantunhui915950@126.com----qok8qzh1
// nongzhanqin4@126.com----bokeycvsl
// yi8193851@126.com----ageosqpwl
// xieju7623067193@126.com----m4z7lavl
// yueshun05731@126.com----g0w962mu
// jicong81628519@126.com----jgctfprg
// weiweitou795@21cn.com----wQKAbDs8iO29
// zuchunteng@21cn.com----hS54eh0W3Pm3
// zhannuo89271@21cn.com----nNo5Aj0a1Q3
// fufengsu1931@21cn.com----pLnn423E9
// gaozhao97@21cn.com----hL98J04R7
// fumei85213@21cn.com----nSZZ4HVv9
// ekao5296017@21cn.com----wGt6KM2o58
// houxian0567@21cn.com----rBi6dGJk1l5
// wenque2497@21cn.com----hMA45elG0
// lengjiao8700@21cn.com----pGQ2UwLE15
// lcg0zfnk@163.com----s1vzma5
// o2rdfy54ycf@163.com----fb2grl18
// y5ihh62@163.com----ut8i20jep
// dq9j4i3of80@163.com----yr2deeuo0
// b577gztu@163.com----wwekfpwqg
// fliqcole1tj@163.com----v2iau1jr
// u5ihtahu48@163.com----a71skxm3
// aklkpcyz@163.com----ccgnu121
// z031lovv87l@163.com----kdgr30w
// o3togtoo@163.com----zmz1zhn
// ba79my1h@163.com----czt4o80m
// qtefd9k4noc@163.com----r6p5m9g
// nw6tmpv@163.com----g7w9cee
// vmaga83r@163.com----y520h103n
// kves05n@163.com----d78eat5
// io70c3g@163.com----b8m40r5
// o0tylu2r3@163.com----gf83eu3lm
// n1iz8hax@163.com----bbxss0m
// l4nh6ciaiya@163.com----pd44u98v
// ugkl625v53@163.com----w8oui6dz4
// znz7y89x@163.com----tnsabg3kp
// q8expvuc80y@163.com----k2c66e4v
// umk2wp9qn@163.com----pqkf3bni7
// dnn50s6t@163.com----wjx0zhs
// boxze91l57@163.com----g21l5vg
// pznf6caiuus@163.com----wh492qb
// i8i0tfeltee@163.com----i62ljcj
// d1ajap1@163.com----jq6s2zxy
// wnmz40owbg8@163.com----c3728p6x
// teodpv8y4pd@163.com----ma64c9at
// ag2in4v71m@163.com----t8niwjq
// tdwoc1ob@163.com----jpfu8or1k
// sxdrp16a@163.com----ae57zvm1
// hr3uge1n@163.com----ebucpx2
// f1k796d9m0s@163.com----m31584d0
// ubbut0pg@163.com----pwsurpx
// a0hbwjwdku@163.com----dpj3p9rry
// u5kp2mte6p@163.com----ye3088ypc
// z2nfemnnp@163.com----vc6jese
// jd1djbr@163.com----ohpenrgzk
// nngn4ssks@163.com----dvf63dlmt
// mk85cyrt@163.com----lnh2j0v5m
// khd8fbwekh9@163.com----b24h4w7ep
// wmjxcx6j5sf@163.com----k7bz2ip6d
// uw4t72xx@163.com----kdxkfoh
// f7478xo4v@163.com----ujpxskrsg
// fo7rkci196v@163.com----u3l13jqq2
// f1f5lj3@163.com----urj4g1a
// w8a468on8q@163.com----iipd9y8
// ttax5x64@163.com----abbio2j7
// qmlkfxe828h@163.com----mwc0jx5y
// l14grd8xcx0@163.com----gefk6esym
// wd9s7sm5@163.com----lizo08jqj
// j76ql4qtuk@163.com----v9x0432
// ffxmf0d6@163.com----unft2oh
// suz1jj844l@163.com----m9mre2z
// ej2h2wt4mtd@163.com----ev960j7ry
// oft7xsdq6z@163.com----vgedpxee
// aqk1z8vcn3t@163.com----w5zna4c3
// gc58yo0b@163.com----etghoh8
// gv41g339c7@163.com----v2nmghh7
// zubnw1m89n@163.com----jsv9bwo3
// lz7e1plbd7@163.com----vr67fk9ui
// l3ag9g6@163.com----c231jw0w
// jvbp5h4hzp8@163.com----wutgvzu4
// g2vu9tify@163.com----n8rb803u
// q8y7yszi0y@163.com----hk587vmc4
// il19c8bab@163.com----x7vce9r9
// un4wu5zp9@163.com----kzz56kw
// g2y76ez2va@163.com----v7zd4d6
// l95xv0jwz6@163.com----pjpn0ju
// h124wnat@163.com----zxugkyd
// zxsi1o3tf6@163.com----z9h8sjwl
// jibi4ur@163.com----ydstk4kx
// cyh1hsqgex@163.com----ofjr5133f
// dtzt6r1yfh9@163.com----my7ed3s
// d0qbwiddrwc@163.com----vtmqj6r
// r4g2a6w@163.com----y9wm6l6n
// q87x80t0@163.com----qho9xz6av
// pl1ziwa@163.com----i4gndd6pp
// ws4i0t7u88b@163.com----ntnb9r5sa
// l4w29db@163.com----syuvv4fs9
// p73w54oq70@163.com----in6elo14r
// ir17n4n0@163.com----dw1i8a41
// uz7yq0i@163.com----y4yu0ic3q
// tvrdcw9@163.com----r7p6v8g
// glyo7i0e@163.com----us06b82s
// b6dnmrp2h@163.com----ivbrfhy81
// pgqkwy5a5@163.com----a2zdwa1a
// j3h1rzpcm@163.com----hcpvcnv9
// ablz3l332rp@163.com----r4rddr7
// thea44qm@163.com----s1nbjay
// q3k353xfe@163.com----cdbcpcji
// tonezzp@163.com----d276ehm
// x6f0ldc@163.com----k56m2gic2
// f36842jcl@163.com----we4smcm7
// kp0ex62yc@163.com----v240534wr
// upnjsw5@163.com----i4514z2
// el99e776@163.com----kfs2e468
// x6bhndjq@163.com----xoh7p5wx
// lengpubi661063@126.com----a76q7f55
// huanai094841@126.com----y5c8k893
// mique1941@126.com----sk1y7agvp
// linfuna709506@126.com----xeox0hw6p
// kebizhong44@126.com----i0fgie8w
// wuzi934746@126.com----v4tl0f8g3
// guyouxian23045@126.com----jck0qcjik
// rongou67758@126.com----i1xloqhm
// shuzai230@126.com----o50rt3qwv
// zhuangyongchou8@126.com----ee39m66cp
// choujuran@126.com----g00hr3wn1
// lirenghe8507403@126.com----pbsyp164
// douzhuo617@126.com----icbn3c5an
// zanliang5787849@126.com----ylmml919
// maohang65@126.com----dcl6g3nq7
// chongyefei@126.com----gek1x9v2x
// baizhanggou@126.com----ak2k9wen
// houyue8733@126.com----yp83l44i
// bandi2049395965@126.com----daojkub4
// maoguan70595406@126.com----mrese1ry
// quqinmi88@126.com----w5wmiixm
// shengbi3840372@126.com----cbovf0gd
// xiongxia169059@126.com----k6br09t9
// sang231324877@126.com----g9vwiucx
// guanhuang56705@126.com----e8sd5i12
// zhonglang460416@126.com----vdnb5j0w3
// zhousou1701@126.com----p55jg3t0w
// yukuangchi637@126.com----lbjhv970
// quyan247173@126.com----ejo43ay1q
// qijie5190950@126.com----hr1nv8b5
// huangyi1982461@126.com----ymczkhv85
// yangtugan@126.com----yw3cff8l
// huaguren687207@126.com----v0b250r7y
// zanyi1683014@126.com----rae60x1k
// huhai017137@126.com----eb58o25ky
// ligongyan33@126.com----t43e0etn
// tantang82986@126.com----zp0xsq5js
// guizhongdu253@126.com----jsw7m753u
// shaoji5507284@126.com----brftvs1b
// hefenzhi4211077@126.com----s7k5h4y0
// nihekan51@126.com----b8p6zno3p
// judun25400@126.com----mc9bbr3z
// fengqunfen31@126.com----wr9jyyd3
// suoweideng09300@126.com----rzmzqjj8p
// jiabei24854@126.com----z768rv3p
// xukong099@126.com----n8jzz45j
// guanlandong2871@126.com----cb44789ux
// daiwei326@126.com----z035bbvf
// tuyiwei298@126.com----moe8rz87o
// hemen68040494@126.com----mc5oidxw9
// fengci3358@126.com----zyg5hofh
// xukeqi888169360@126.com----m55oalflb
// huaiji9984197@126.com----v4l9sb2w
// luyunwo9338012@126.com----nguv47in
// dangjiaya662235@126.com----v0l6a3tr
// songzhidu1@126.com----xjfeabhgy
// pushai0941@126.com----n7kt4irl
// dengdaowo169@126.com----y7fnj9os
// shenye929@126.com----qs7xnh560
// cengmei5271727@126.com----z2b7nzza
// shenuoyan093850@126.com----ebc0tffns
// yangshangya2986@126.com----j9puhqmu
// ruanyuan2@126.com----sj7jle5so
// shenshangshuo35@126.com----y6ntzi94i
// xuwei883663@126.com----coemdt3ds
// balianxi057743@126.com----zfh97wwy
// liangqiang64628@126.com----acf2w16x
// xiezi57498495@126.com----s3wghyzs
// dangju690491@126.com----of69reur
// tuyi35172974@126.com----hgemvp5u
// luguanjiu501@126.com----l3zs9gstn
// xiazhi5608642@126.com----csm43ul88
// manqiao5698@126.com----u31suy7zf
// pengwen09360@126.com----ilndma0jm
// luleiliao9781@126.com----tbrwiiby
// biranyue5@126.com----qil8b6s1
// daian4939@126.com----v6d00u30
// wengzong51@126.com----r41ci6637
// chouxie21@126.com----l8s5wr74
// che76926942479@126.com----a9x1qlmta
// mieshi442350@126.com----wkskx19cr
// wutong341@126.com----ceomo091w
// yuanhan8194242@126.com----cb89uaikp
// zhongpu3619@126.com----yq1zg1wo
// wanlin90852@126.com----tx0n3z7fx
// yuyu6054280008@126.com----n6lrfitl3
// zulangnuo702@126.com----aayg5j95
// chapu99015957@126.com----o7m0f4f76
// quganle759426@126.com----w4vimjlq
// ronglao26177667@126.com----b8sgf3s3a
// yubi3718664084@126.com----g4nfcx3cb
// feimei19057070@126.com----mxlej429k
// cheyiqi69441@126.com----oh8dnbv69
// heyou505308@126.com----y2e4urb1
// zonglu2922@126.com----vi0kh5nv
// jique33599387@126.com----wkv7zql5
// haoqiao91516226@126.com----znbias0u
// lianji560370354@126.com----qzhy75sd
// yongmei5570@126.com----m71c647ji
// yanyuancai11@126.com----e1d4td9nl
// a3y6958eyw@163.com----bo3lfzu
// rd1b8o8y0q5@163.com----xy400g2cs
// uyxjcc3w@163.com----f72ycq77
// ev5smwqn@163.com----wgwabzcc
// gi6lq8b@163.com----xnfxs9y
// n0qtgcl2@163.com----iu64naxt1
// j92h1c7@163.com----dnyq94c
// kfqg1m2ebq@163.com----rng9osm69
// z1xriz4am@163.com----joinzq68
// nx151vh@163.com----x70yfqm4
// y355agfzuh@163.com----d1j4k8l
// w7xzirxvxlg@163.com----imx73kp
// serrl6kv@163.com----yg6182w
// z747bhjd@163.com----fdry4ly
// ibte67q@163.com----fmblo2bw
// wf459jzpyuq@163.com----r7z5wvq7b
// t5zdjwcq6@163.com----vj678ycq
// dcfup0ru9c@163.com----dl3ns9z1
// xfzkey1r1@163.com----h8js7l00p
// q0e8y6g28@163.com----rq88jwn2
// csz8u9hfmr@163.com----e5kk2ruiy
// bz26mi2cjqe@163.com----vy6ehn1iz
// l1345dslu@163.com----g4sdw67j
// ne91xy5@163.com----ui70q6o6
// py44b4ho8g@163.com----qzow29h0v
// pfe1xtbc1g@163.com----k0drr6x8
// fk0wo5ptakc@163.com----bznuk2wtb
// xfp4b41q@163.com----nuwm0myx
// yhretro60q4@163.com----t8t6wrx
// us5y1nummjx@163.com----xdo89zn
// rfwoi2d3074@163.com----j0s7gfst3
// bdcfd11ts@163.com----mrpkbjbe
// o7bn713n@163.com----ntiom70q
// xmjctnk7if9@163.com----j8olt504
// rimhtaih7xp@163.com----izggc9i2
// appcau6@163.com----zv1a8i959
// wt1sqt9@163.com----yuoi916hc
// hn8u5vw7i@163.com----oarty4wxf
// ai07ytbm@163.com----qicvwdr
// cjmagt2@163.com----merc4ky
// imr52lcv@163.com----hiun779
// g8t1434b@163.com----x8sn6i9ci
// xlmfz2r@163.com----j5hk6yr6
// hmvvno01u0@163.com----h1av0jp
// xiuustop@163.com----e2xq5lz
// ivs0cepd7xw@163.com----w32s683ze
// garl6cqk@163.com----l31w98y
// a92oaus65u@163.com----o8et5wic4
// qsqczsrty@163.com----jtt3iy338
// cdz24tsal@163.com----kj683s2
// j02p9y0asu@163.com----v9qrvcp93
// jfwy1xe3zkl@163.com----nh6ivvd
// nqca42h2qr8@163.com----dvbzrc6
// alacx9jeo@163.com----w8uajrk56
// jx9rmevhyl@163.com----zkre0pr
// sgkl721694@163.com----o67mmej
// wwn1sasm1@163.com----pvq2z68
// ypt33deqyaw@163.com----s8c5hk8n9
// j6ovqc65qc@163.com----rhewg3nb
// ziudye4@163.com----b8526nub
// ykksd1io3ai@163.com----xn60kvh
// st9xk2j@163.com----llq7wjd1
// f1u7xa2@163.com----kb009a5di
// leuf3uh@163.com----mhj7aruqk
// ller136eci6@163.com----on83jb3i9
// g3g4m0al@163.com----d70qy3y
// sf50jc986@163.com----lavbv2xv
// rcbf7rt@163.com----ow1wq4cp
// axvnhi4oc@163.com----zbbnag1
// xcuitam2kip@163.com----jfg7fg19
// rc2rkt7d@163.com----j1cvx9se2
// d41s21asag@163.com----l5uyy9rzn
// ba7lg31x1@163.com----l9che90
// s3yc7qo3nf@163.com----gefyj0iv
// ilejw87o3by@163.com----j6024wa7
// mo544jr@163.com----pxtsgv5
// n9c29j87xr7@163.com----y6ji4uc
// nyjoghpjxcp@163.com----xesq4qdah
// lnddyz9rj@163.com----rzxmxreo
// d6r7y57@163.com----qc8l54w
// gounuo089257651@126.com----ny5n8hq3k
// guanjuju26@126.com----ia01bj2o
// mohua81683082@126.com----aece2t9s
// changpinjiu682@126.com----uj2qnki23
// herong63078@126.com----h80u4noef
// suca83965@126.com----ir52uk8q
// lugua827972@126.com----v0q22j9se
// aiza592350284@126.com----eovgbnqn1
// lianmeiyue66@126.com----feena09w6
// zoujiao38328964@126.com----xt49m23l0
// miejiushao1134@126.com----k7k5mcso
// danchao91382874@126.com----iok36kf7a
// bianzhituan300@126.com----ftc6w1ma
// gongouchen03262@126.com----qltqyh5jj
// ruxie2287438@126.com----o7lzg3h18
// shulanshan0115@126.com----doi5v2r1s
// nenglian504006@126.com----vb2wji0r
// chusuyuan541494@126.com----cm91kqtd
// fenghanmu@126.com----ef3x3gj9t
// naganci27922333@126.com----xaaa2bbx
// mengbagu62@126.com----f715yr62l
// bapaoxin87201@126.com----a9ik30l93
// zongguju42655@126.com----el074kyae
// kounaoyun211@126.com----xi2rzrx2q
// duyehuai72259@126.com----cwf15680
// yushi6333755867@126.com----z38v33bg
// yangwuliao8@126.com----e8plsmju
// xiachen2262@126.com----tcq50jrhb
// jingpiao9948429@126.com----i7cvaz6l
// yangpang9383849@126.com----hmrqwpsd
// shuijia2093@126.com----qm8ju447
// caihui0167305@126.com----kevdeohv
// yishixing5@126.com----q1ba42dm
// weiwoshi9@126.com----ww880n5g
// rankan589@126.com----f4vzxtpme
// caiqielu25524@126.com----iuu3saujg
// xiebaji4768037@126.com----wsq4p4dnp
// lushang507441@126.com----izxqcsia
// yufutu81349@126.com----yb525qwy4
// woweiping5@126.com----nlcor3ng4
// pudibu6136194@126.com----alua5emv
// yangshi69218887@126.com----rr9z97xq5
// niubajia792@126.com----ee8v3029
// cengtang0168713@126.com----u2hw75do
// feishoushi80@126.com----eyjn034p3
// gengguai8916134@126.com----qw989gb8
// luoulu486@126.com----fv9mi6dml
// putuijia4985645@126.com----f0xku79gr
// dibayi56187643@126.com----l49269383
// maosha5902@126.com----kfkqivc9
// zoujiaoju@126.com----sg4h1tso
// honggua002971@126.com----soipn3oe
// qiumeina69157@126.com----yv7e8ytcq
// wangsusha8@126.com----b8qkr54tb
// yinggaibei0@126.com----uzi3135e
// shubituo9381605@126.com----jowcut9wn
// quyun91087639@126.com----b0d43xjn
// fuwenke839529@126.com----tthrzt3io
// yiben20706117@126.com----pmgql5xt
// jiannatang9615@126.com----aj1qsrqv
// pengyan200@126.com----twe4srni
// jiasizhi07@126.com----t5lm2one
// langyun3997153@126.com----jt240fqlw
// xian5846046@126.com----zn1r7lk2
// luping08944800@126.com----lxg9fl5o
// kanyanye69@126.com----o77fw7j04
// jiliao106431293@126.com----a8e0e85rb
// caokaoqiao1@126.com----ep2dtgsy
// fangque22892@126.com----l5q2q44wa
// yuanmie3813814@126.com----y18jeh6z
// yangshixia07@126.com----j1bwplvyj
// xikangsu70@126.com----wgaz2kg3p
// nongdun022592@126.com----ycw34cux
// jingua45523@126.com----q3wr2ngj
// hupo8795573081@126.com----muer00y4
// hongxia57378739@126.com----f8gva57z
// laomeng43@126.com----wszie11sb
// gengchao24@126.com----jpa9t1wa
// ruantui5117@126.com----j5kmzca4e
// huoping38@126.com----g2973c2h
// np7sdr7@163.com----we35r29ry
// rtqjrkzm5@163.com----rk7iy0tsf
// ylz59fi@163.com----oeo8e42m
// pze5kes9@163.com----amz6gjku
// v6j0g14tv@163.com----v4hh2ay
// um6c44r@163.com----xruwroe
// p45t0w2j@163.com----ibnk90j
// y3umsz985@163.com----u4dry5lm2
// mo3q4qv6@163.com----va7ijir50
// tsr8sfk0@163.com----bncs9hs6`.split(/[\s\n]/).map((v, index) => ({
//     email: v.split('----')[0], id: index, subject: '债权转让通知<公司内测>',
//     content: '债权转让通知\r\n\r\n债权转让通知«姓名»,«身份证号»，您通过“«产品名称»”签订的编号为“«channel_order_no»”的《借款合同》（下称“合同”），借款合同编号为“«借款合同编号»”因您逾期未还，我公司已将享有对您的前述债权转让给衡阳市申宏资产经营管理有限公司，债权转让后的权力义务，按原协议约定处理。您应自收到本债转通知之日起向衡阳市申宏资产经营管理有限公司履行还款义务。\r\n\r\n本通知自形成之日即发生法律效力，特此通知！\r\n                    “«产品名称»”\r\n                   鹰潭市信江广达小额贷款股份有限公司2020年  4月  26日\r\n\r\n\r\n\r\n附：债权受让人名称：衡阳市申宏资产经营管理有限公司\r\n开户行:衡阳市农村商业银行高铁支行\r\n账号:82011150001332046\r\n联系电话：0734-8168652\r\n18684909588',
//   }));

const Service = require('egg').Service;
const puppeteer = require('puppeteer');
const fs = require('fs');
const path = require('path');
const queueName = 'test';
const cookiePath = '../public/data/cookies.json';

const validate = result => {
  if (result.code !== 2000) throw new Error(result && result.msg || '服务器异常');
  return result.data;
};

class HomeService extends Service {
  async getMails() {
    const { ctx } = this;
    const limit = 150;
    console.log(`${ctx.app.config.legal.host}/api/email/get/${limit}`);
    const { data: result } = await ctx.curl(`${ctx.app.config.legal.host}/api/email/get/${limit}`, {
      dataType: 'json',
      method: 'POST',
    });

    return validate(result);
  }

  async updateStatus(mails) {
    const { ctx } = this;
    console.log(`${ctx.app.config.legal.host}/api/email/callback`);
    const { data: result } = await ctx.curl(`${ctx.app.config.legal.host}/api/email/callback`, {
      contentType: 'json',
      dataType: 'json',
      method: 'POST',
      data: mails,
    });

    return validate(result);
  }

  async schedule() {
    const { ctx, app } = this;
    const resource = 'locks:puppeteer';
    const ttl = 60 * 1000;
    let lock = null;
    ctx.logger.info('发送任务开始');

    try {
      lock = await app.redlock9.lock(resource, ttl);
      ctx.logger.info('获取锁成功');
      const mails = await this.getMails();
      const result = await this.sendMail(mails);
      this.ctx.logger.info(result);
      await this.updateStatus(result);
      if (lock) lock.unlock();
    } catch (e) {
      ctx.logger.error((e && e.message) || '出现未知错误');
      if (!lock) {
        ctx.logger.info('未获取到锁');
        return;
      }
      lock.unlock();
    }
  }

  async sendMail(mails) {
    const { ctx, service } = this;
    const result = [];
    const browserConfig = {
      args: [ '--no-sandbox', '--disable-setuid-sandbox' ],
      headless: true,
      defaultViewport: {
        width: 1024,
        height: 1000,
      },
    };
    let cookie = fs.readFileSync(path.join(__dirname, cookiePath)).toString();
    try {
      const browser = await puppeteer.launch(browserConfig);
      const page = await browser.newPage();
      if (cookie) await ctx.helper.addCookies(JSON.parse(cookie), page);
      await page.goto('https://exmail.qq.com');
      ctx.logger.info('tecent mail: 进入https://exmail.qq.com');
      const btnlogin = await page.$('.index_topbar_btn_login');
      const btlogin = await page.$('#btlogin');

      // 未登录状态先进行登录
      if (btnlogin || btlogin) {
        ctx.logger.info('tecent mail: 未登录进行登录');
        if (btnlogin) {
          await page.goto('https://exmail.qq.com/login');
          await page.click('.js_show_pwd_panel');
        }
        await page.$eval('#inputuin', input => { input.value = ''; });
        await page.type('#inputuin', ctx.app.config.tecent.account);
        await page.type('#pp', ctx.app.config.tecent.password);
        await page.click('#auto_login_in_five_days_pwd');
        await page.click('#btlogin');
        await page.waitForNavigation({ waitUntil: 'load' }); // 等待页面加载出来，等同于window.onload
        let VerifyArea = await page.$('#VerifyArea');
        if (VerifyArea) {
          let j = 0;
          ctx.logger.warn('tecent mail: 登录需要输入验证码!');
          while (VerifyArea && j < 100) {
            j++;
            ctx.logger.warn(`tecent mail: 第${j}次输入验证码!`);
            await ctx.helper.writeTecentLoginCode(page);
            await page.waitFor(5000);
            VerifyArea = await page.$('#VerifyArea');
          }
          if (j === 100) throw new Error('验证码尝试过多');
        }
        cookie = await page.cookies('https://exmail.qq.com');
        fs.writeFileSync(path.join(__dirname, cookiePath), JSON.stringify(cookie));
      }
      ctx.logger.info('tecent mail: 已登录');
      for (let i = 0; i < mails.length; i++) {
        const email = mails[i].email;
        ctx.logger.info(`tecent mail: 准备发送第${i + 1}封邮件 mail: ${email}`);
        await page.click('#composebtn');
        const mainFrame = await page.frames().find(f => f.name() === 'mainFrame');
        await mainFrame.waitFor(3000);
        await mainFrame.waitFor('#subject');
        await mainFrame.waitFor('.addr_text>input');
        await mainFrame.type('.addr_text>input', email);
        await mainFrame.type('#subject', mails[i].subject);
        const bodyFrame = await mainFrame.childFrames()[2];
        await bodyFrame.type('body', mails[i].content);
        await mainFrame.click('input[name="sendbtn"]');

        await mainFrame.waitFor(3000);
        const isNeedCode = await page.$('#QMVerify_s_vfcode');
        if (isNeedCode) throw new Error('发送邮件需要输入验证码！');

        await mainFrame.waitFor('#readSendbox>a');
        await mainFrame.click('#readSendbox>a');
        await mainFrame.waitFor(5000);
        const mailSendStatusFrame = await mainFrame.childFrames().find(f => f.name() === 'mailSendStatus');
        await mailSendStatusFrame.waitFor('#statusbtn');
        await mailSendStatusFrame.waitFor('#clickstu');
        await mailSendStatusFrame.click('#clickstu');
        let sendStatus = await mailSendStatusFrame.$eval('#statusbtn', el => el.innerHTML);
        const receiver = await mailSendStatusFrame.$eval('.oneline', el => el.innerHTML);
        if (sendStatus === '正在投递') {
          await mailSendStatusFrame.waitFor(10000);
          const clickStatus = await mailSendStatusFrame.$eval('#clickstu', el => el.innerHTML);
          if (clickStatus === '[查看详情]') await mailSendStatusFrame.click('#clickstu');
          await mailSendStatusFrame.click('#refreshbutton');
          await mailSendStatusFrame.waitFor(2000);
          sendStatus = await mailSendStatusFrame.$eval('#statusbtn', el => el.innerHTML);
        }

        if (!receiver.includes(email)) {
          ctx.logger.error('收件箱不一致, 投递失败');
          continue;
        }

        if (sendStatus !== '投递成功') {
          ctx.logger.error(sendStatus || '投递失败');
          continue;
        }

        await page.mouse.move(0, 0);
        const mainFrameContainer = await page.$('#mainFrameContainer');
        const imageName = `${email}_${Date.now()}.png`;
        await mainFrameContainer.screenshot({ path: `./app/public/images/${imageName}` });
        const imagePath = await service.fdfs.upload(path.join(__dirname, `../public/images/${imageName}`));
        result.push({ id: mails[i].id, url: imagePath });
        await mainFrame.waitFor(parseInt((Math.random() * 3 + 1) * 1000, 10));
      }
      await browser.close();
    } catch (e) {
      await service.dingTalk.push(e && e.message);
      ctx.logger.error(e);
    }
    return result;
  }

  async publisher() {
    const ch = await this.app.amqplib.createChannel();
    await ch.assertQueue(queueName, { durable: false });
    for (let i = 0; i < 5; i++) {
      await ch.sendToQueue(queueName, Buffer.from(`第${i}条消息`));
    }
    await ch.close();
  }

  async consumer() {
    let ch;
    try {
      ch = await this.app.amqplib.createChannel();
      await ch.assertQueue(queueName, { durable: false });
      await ch.prefetch(1, false);
      let i = 0;
      await ch.consume(queueName, msg => {
        try {
          i++;
          console.log('consumer', msg.content.toString());
          if (i === 1) { throw new Error('出现异常'); }
          ch.ack(msg);
        } catch (err) {
          this.ctx.logger.error(err);
          ch.close();
        }
      }, { noAck: false });
    } catch (err) {
      this.ctx.logger.error(err);
      if (ch) ch.close();
    }
  }
}

module.exports = HomeService;
