/* eslint valid-jsdoc: "off" */

'use strict';

/**
 * @param {Egg.EggAppInfo} appInfo app info
 */
module.exports = appInfo => {
  /**
   * built-in config
   * @type {Egg.EggAppConfig}
   **/
  const config = exports = {
    onerror: {
      all(err, ctx) {
        // 在此处定义针对所有响应类型的错误处理方法
        // 注意，定义了 config.all 之后，其他错误处理方法不会再生效
        ctx.set({
          'Content-Type': 'application/json',
        });
        ctx.status = 200;
        ctx.body = {
          code: '0001',
          businessCode: '0001',
          message: err && err.message || '服务出现异常, 请稍后重试',
        };
      },
    },
    amqplib: {
      client: {
        url: 'amqp://qa:qatest@172.17.5.8:31342/egg-puppeteer',
      },
    },
  };

  // use for cookie sign key, should change to your own and keep security
  config.keys = appInfo.name + '_1587451410000_2082';

  // add your middleware config here
  config.middleware = [ 'handler' ];

  // add your user config here
  const userConfig = {
    // myAppName: 'egg',
  };

  const mailConfig = {
    aliyun: [
      { account: 'xyqb@liangkebang.net', password: 'Ztg202020' },
    ],
    tecent: { account: 'Tiange.zeng@lkbang.com', password: 'Ztg2020' },
    smtp: {
      host: 'smtp.mxhichina.com',
      port: 465,
      secure: true, // use SSL
      auth: {
        user: 'xyqb3@liangkebang.net',
        pass: 'Ztg202020', // 这是邮箱的授权码不是登录密码。 安全登录的客户端专用密码：
      },
    },
    legal: {
      host: 'http://back-law-urge.q-gp.com',
    },
  };

  const fdfsConfig = {
    fdfs: {
      // tracker servers
      trackers: [
        {
          host: 'tracker-fdfs1.quantgroups.com',
          port: 22122,
        },
        {
          host: 'tracker-fdfs2.quantgroups.com',
          port: 22122,
        },
      ],
      // 默认超时时间10s
      timeout: 10000,
      // 默认后缀
      // 当获取不到文件后缀时使用
      defaultExt: 'png',
      // charset默认utf8
      charset: 'utf8',
    },
  };

  const redisConfig = {
    redis: {
      client: {
        sentinels: [
          {
            host: 'opapi-redis1.quantgroups.com',
            port: 26379,
          },
          {
            host: 'opapi-redis2.quantgroups.com',
            port: 26379,
          },
          {
            host: 'opapi-redis3.quantgroups.com',
            port: 26379,
          },
        ],
        name: 'mymaster',
        password: '',
        db: 0,
      },
    },
  };

  const redlock = {
    redlock9: {
      logger: app => e => app.info(e.message), // logger when lock failed, can be false
      options: {
        driftFactor: 0.01, // time in ms
        retryCount: 0,
        retryDelay: 200, // time in ms
        retryJitter: 200, // time in ms
      },
    },
  };

  return {
    ...config,
    ...userConfig,
    ...mailConfig,
    ...fdfsConfig,
    ...redisConfig,
    ...redlock,
  };
};
