# cauchy-ui

基于vue-cli 3.0的h5商城

## Feature

- **对项目结构进行细微优化**。对各资源模块进行归类、细分；编写、维护、查找更便利。

- **数据请求策略化**。对axios封装，统一请求配置，可配置针对不同业务接口返回参数的处理。

- **内置样式处理方案**。支持less编译，并内置变量和mixin，轻松开启样式编写、复用、修改等。

- **集成组件库**。可通过cherry-ui快速开发功能，配置全局主题风格。

- **集成 Prettier & Eslint**。检测代码潜在问题的同时，统一团队代码规范。

- **集成git hooks**。只允许提交符合规范的代码，保持代码库干净整洁。

- **打包资源自动上传cdn**。项目代码上传cdn，加快访问速度。

## Directory

```bash

├── README.md          // 项目说明
├── babel.config.js    // babel配置
├── .browserslistrc    // 目标浏览器配置
├── .editorconfig      // 编辑器统一编码规范配置
├── .eslintignore      // eslint忽略清单
├── .eslintrc.js       // eslint配置
├── .gitignore         // git忽略清单
├── .prettierrc.js     // prettier配置
├── .sentryclirc.js    // sentry配置
├── jsconfig.json      // vsc js配置
├── vue.config.js      // vue-cli3主配置
├── package-lock.json  // package.json锁定
├── yarn.lock          // package.json锁定-yarn
├── package.json       // npm配置
├── postcss.config.js  // postcss配置
├── .env.production    // 生产环境变量配置
├── .env.development   // 开发环境变量配置
├── .env.test          // 测试环境变量配置
│
├── public          // 公用文件，不经过webpack处理
│   ├── fixIosTitle.html // ios兼容修改title
│   ├── index.html
│   └── logo.png
│
└── src
    ├── main.js   // 主入口
    ├── App.vue   // 主页面
    ├── api   // 接口层
    │   └── common.js    // 原则：按接口或业务区分不同文件夹
    │
    ├── assets    // lottie动画、image、svg等资源
    │   ├── images  // image图标库
    │   │   └── pay   // 不同业务对应不同文件夹
    │   │       └── xhk.png
    │   ├── logo-txt.png
    │   ├── logo.png
    │   ├── lottie  // lottie动画库
    │   │   └── red-card-popup.json
    │   └── svg     // svg图标库
    │       └── ufo.svg
    │
    ├── components    // 业务公用组件、原子组件
    │   ├── LoginForm.vue
    │   ├── NetError.vue
    │   ├── PayWaitLayer.vue
    │   ├── SvgIcon.vue     // svg公共组件
    │   └── lottie.vue      // lottie动画公共组件
    │
    ├── config    // 配置层，包括常量配置、接口配置
    │   ├── constant.js     // 常量
    │   ├── dev.config.js   // 本地开发环境配置
    │   ├── index.js        // 聚合
    │   └── prod.config.js  // 生产/测试环境配置
    │
    ├── mixins    // 公共mixins
    │   ├── formValidate.mixin.js
    │   └── inputFix.mixin.js
    │   
    ├── router    // 路由层
    │   ├── index.js    // router功能配置、路由监听
    │   └── routes.js   // 所有路由
    │   
    ├── service  // 工具层
    │   ├── cherry-ui.js    // ui库按需引入
    │   ├── cookie.js       // cookies操作
    │   ├── http.js         // axios二次封装
    │   ├── init.service.js // 路由鉴权、修改title
    │   ├── localstorage.js // localstorage操作
    │   ├── pay.js          // 支付
    │   ├── sa.js           // 神策
    │   ├── svg.js          // 生成
    │   ├── utils.js        // 工具库
    │   ├── validation.js   // 校验规则
    │   └── vconsole.js
    │   
    ├── store   // vuex数据
    │   └── index.js
    │   
    ├── style   //所有less资源
    │   ├── iconfont.less   // iconfont
    │   ├── index.less      // 聚合
    │   ├── mixins.less     // mixins
    │   ├── reset.less      // 兼容各浏览器
    │   ├── theme.less      //ui库主题定制
    │   └── var.less        // less变量和function等
    │   
    └── views    // UI层(原则：轻page，重component)
        └── Home
            ├── Demo  // 业务
            │   ├── index.less  // 业务样式（少可以不分离，但建议分离）
            │   └── index.vue   // 业务page
            └── modules   // 业务功能组件
                └── Child.vue
```
