import * as types from './type';

const state = {
  header: true,
  title: '支付中心',
  loading: false,
  meta: {}
};

// getters
const getters = {};

// actions
const actions = {
  change_header({ commit }, header) {
    commit(types.CHANGE_HEADER, header);
  },
  change_title({ commit }, title) {
    commit(types.CHANGE_TITLE, title);
  },
  change_meta({ commit }, meta) {
    commit(types.CHANGE_META, meta);
  },
  change_loading({ commit }, loading) {
    commit(types.CHANGE_LOADING, loading);
  }
};

// mutations
const mutations = {
  [types.CHANGE_HEADER](state, header) {
    if (header !== undefined) {
      state.header = header;
    }
  },
  [types.CHANGE_LOADING](state, loading) {
    state.loading = loading;
  },
  [types.CHANGE_TITLE](state, title) {
    if (title) {
      state.title = title;
    }
    document.title = state.title;
    // 如果是 iOS 设备，则使用如下 hack 的写法实现页面标题的更新
    if (/ip(hone|od|ad)/i.test(navigator.userAgent.toLowerCase())) {
      const hackIframe = document.createElement('iframe');
      hackIframe.style.display = 'none';
      hackIframe.src = '/public/fixIosTitle.html?r=' + Math.random();
      document.body.appendChild(hackIframe);
      setTimeout(() => {
        document.body.removeChild(hackIframe);
      }, 300);
    }
  },
  [types.CHANGE_META](state, meta) {
    for (let i in meta) {
      state.meta[i] = meta[i];
    }
  }
};

export default {
  state,
  getters,
  actions,
  mutations
};
