import * as types from './type';

const state = {
  header: true,
  title: '支付中心',
  loading: false,
  meta: {}
};

// getters
const getters = {};

// actions
const actions = {
  change_header({ commit }, header) {
    commit(types.CHANGE_HEADER, header);
  },
  change_title({ commit }, title) {
    commit(types.CHANGE_TITLE, title);
  },
  change_meta({ commit }, meta) {
    commit(types.CHANGE_META, meta);
  },
  change_loading({ commit }, loading) {
    commit(types.CHANGE_LOADING, loading);
  }
};

// mutations
const mutations = {
  [types.CHANGE_HEADER](state, header) {
    if (header !== undefined) {
      state.header = header;
    }
  },
  [types.CHANGE_LOADING](state, loading) {
    state.loading = loading;
  },
  [types.CHANGE_TITLE](state, title) {
    if (title) {
      state.title = title;
    }
    setTimeout(function() {
      //利用iframe的onload事件刷新页面
      document.title = state.title;
      var iframe = document.createElement('iframe');
      iframe.style.visibility = 'hidden';
      iframe.style.width = '1px';
      iframe.style.height = '1px';
      iframe.onload = function() {
        setTimeout(function() {
          document.body.removeChild(iframe);
        }, 0);
      };
      document.body.appendChild(iframe);
    }, 0);
  },
  [types.CHANGE_META](state, meta) {
    for (let i in meta) {
      state.meta[i] = meta[i];
    }
  }
};

export default {
  state,
  getters,
  actions,
  mutations
};
