import Vue from 'vue';
import sa from 'sa-sdk-javascript';
import config from '@/config';
export default {
  init: function(router) {
    sa.init({
      server_url: config.shenceHost,
      heatmap: {
        //是否开启点击图，默认 default 表示开启，自动采集 $WebClick 事件，可以设置 'not_collect' 表示关闭
        clickmap: 'default',
        //是否开启触达注意力图，默认 default 表示开启，自动采集 $WebStay 事件，可以设置 'not_collect' 表示关闭
        scroll_notice_map: 'default'
      },
      //判断外层是否有 App 的 SDK ，如果有的话，会往 App 的 SDK 发数据。如果没有，就正常发送数据。
      use_app_track: true,
      show_log: config.test,
      app_js_bridge: true
    });
    // 添加公共属性
    sa.registerPage({
      platformType: 'H5',
      uuid: '',
      qg_device_id: '',
      channel_code: '',
      splitStream: ''
    });
    router.afterEach(() => {
      Vue.nextTick(() => {
        sa.quick('autoTrackSinglePage');
      });
    });
  }
};
export function registeredEvents(eventName, eventData, callback = () => {}) {
  sa.track(eventName, eventData, callback);
}
// 用户登录神策埋点
export function loginSa(uuid = localStorage.get('uuid')) {
  if (!uuid) return;
  localStorage.set('uuid', uuid);
  sa.login(uuid);
}

export function saDeviceId() {
  return new Promise(resolve => {
    sa.quick('isReady', function() {
      resolve(sa.quick('getAnonymousID'));
    });
  });
}
