import cookies from 'js-cookie';
const option = {
  domain: window.location.host.indexOf('.q-gp.com') >= 0 ? '.q-gp.com' : '',
  expires: 1
};
const Cookies = {
  get(key) {
    const result = cookies.get(key);
    try {
      return JSON.parse(result);
    } catch (e) {
      return result;
    }
  },
  set(key, value) {
    return cookies.set(key, value, option);
  },
  clear() {
    return Object.keys(cookies.get()).forEach(function(cookie) {
      Cookies.remove(cookie, option);
    });
  },
  remove(key) {
    return cookies.remove(key, option);
  }
};

export default Cookies;
