import request from '@/service/httpDecorator';
import config from '@/config';
const { talosHost } = config;

const queryPayInfo = function(data) {
  return request.post(`${talosHost}/open/checkout`, data);
};
const prepay = function(data) {
  console.log('prepay-param', data);
  return request.post(`${talosHost}/open/checkout/prepay`, data);
};

const pay = function(data) {
  return request.post(`${talosHost}/open/checkout/pay`, data, {
    needScDeviceId: true
  });
};

const queryPayStatus = function(data) {
  return request.post(`${talosHost}/open/checkout/pay_status/query`, data);
};

const sendSms = function(data) {
  return request.post(`${talosHost}/open/checkout/send_sms`, data);
};

const desSalt = function() {
  return request.get(`${talosHost}/vcc/account/salt`);
};

const h5AppyUrl = function() {
  return request.get(`${talosHost}/vcc/xyqb_mall/app_url`);
};

const getCoupon = function(params) {
  return request.post(`${talosHost}/open/checkout/pay_coupon_list`, params);
};

const ocrFaceId = function(params) {
  return request.post(`${talosHost}open/checkout/ocr_faceId`, params);
};

export {
  pay,
  prepay,
  sendSms,
  queryPayInfo,
  queryPayStatus,
  desSalt,
  h5AppyUrl,
  getCoupon,
  ocrFaceId
};
