import config from '@/config';
import http from '@/service/httpDecorator';
import { encryption } from '@/service/encrypt';
const { talosHost } = config;

export default {
  // 订单列表
  orderList(data) {
    // TODO 测试
    return http.get(`${talosHost}/api/kdsp/order-info/virtual-recharge/list`, { params: data });
  },
  // 用户订单确认收货接口
  orderConfirm(data) {
    return http.post(`${talosHost}/api/kdsp/order-info/receipt/confirm`, data);
  },
  // 用户订单取消接口【未付款】
  orderCancel(data) {
    return http.post(`${talosHost}/api/kdsp/order-info/cancel`, data);
  },
  // 订单详情查询接口
  orderDetail(data) {
    return http.get(`${talosHost}/api/kdsp/order-info/virtual-recharge/detail`, { params: data });
  },
  // 订单创建
  orderCreate(data) {
    console.log(data);
    return http.post(`${talosHost}/api/kdsp/order-info/e/vmSubmit`, encryption(data));
  }
};
