import cookies from '@/service/cookieStorage.service';
export const goUrlExtends = {
  methods: {
    goHome(payStatus) {
      // 商城地址
      if (payStatus) {
        this.$track.registeredEvents('h5_RechargeResultPageClick', {
          pay_status: payStatus,
          buttons_name: '返回首页'
        });
      }
      const returnUrl = this.getReturnUrl();
      setTimeout(() => {
        if (returnUrl) {
          window.location.replace(`${returnUrl}`);
          return;
        }
        this.$router.replace({ name: 'vipLife' });
      }, 500);
    },
    goOrderList(payStatus) {
      if (payStatus) {
        this.$track.registeredEvents('h5_RechargeResultPageClick', {
          pay_status: payStatus,
          buttons_name: '查看订单'
        });
      }
      const returnUrl = this.getReturnUrl();
      setTimeout(() => {
        if (returnUrl) {
          window.location.replace(`${returnUrl}/orderList`);
          return;
        }
        this.$router.replace({ name: 'orderList' });
      }, 500);
    },
    goOrderDetail() {
      const returnUrl = this.getReturnUrl();
      const orderNo = cookies.get('orderNo')?.orderNo;
      if (returnUrl) {
        window.location.replace(`${returnUrl}/orderDetail?orderNo=${orderNo}`);
        return;
      }
      this.$router.push({
        name: 'orderDetail',
        query: { orderNo }
      });
    },
    getReturnUrl() {
      const returnUrl = cookies.get('returnUrl');
      return returnUrl;
    }
  }
};
