export default [
  {
    path: '/',
    redirect: '/pay'
  },
  {
    path: '/pay',
    name: 'pay',
    meta: {
      title: '收银台'
    },
    component: () => import('../pay')
  },
  {
    path: '/payFail',
    name: 'payFail',
    alias: ['/payFail'],
    meta: {
      title: '支付失败'
    },
    component: () => import('../pay/payResult')
  },
  {
    path: '/paySuccess',
    name: 'paySuccess',
    alias: ['/paySuccess'], // 有问题🤨
    meta: {
      title: '支付成功',
      success: true
    },
    component: () => import('../pay/payResult')
  },
  {
    path: '/vipLife',
    name: 'vipLife',
    meta: {
      title: '充值中心'
    },
    component: () => import('../views/vipLife')
  },
  {
    path: '/orderList',
    name: 'orderList',
    meta: {
      title: '我的订单'
    },
    component: () => import('../views/orderList')
  },
  {
    path: '/orderDetail',
    name: 'orderDetail',
    meta: {
      title: '订单详情'
    },
    component: () => import('../views/orderDetail')
 },{
    path: '/payWaiting',
    name: 'payWaiting',
    meta: {
      title: '支付中',
      success: true
    },
    component: () => import('../pay/payWaiting')
  },
  {
    path: '/demo',
    alias: ['/demo-page'],
    name: 'demo-page',
    back: false,
    meta: {
      title: 'DEMO',
      has: {
        header: true,
        footer: true
      }
    },
    component: () => import('../views/demo')
  },
  {
    path: '/error',
    name: 'error',
    meta: {
      title: '出错了'
    },
    component: () => import('../components/error')
  },
  {
    path: '*',
    name: 'notFound',
    meta: {
      title: '找不到页面'
    },
    component: () => import('../components/error/NotFound')
  }
];
