const TXT_SIZE = 17;
const TXT_MIN_SIZE = 12;

export default {
  inserted(el, binding) {
    let txtSize = binding.value || TXT_SIZE;
    const containerWidth = el.offsetWidth;
    const txtLength = el.innerText.length * TXT_SIZE;
    const overTxtWidth = txtLength - containerWidth;
    if (overTxtWidth > 0) {
      const overSize = Math.ceil(overTxtWidth / TXT_SIZE);
      txtSize = txtSize - overSize;
    }
    txtSize = txtSize < TXT_MIN_SIZE ? TXT_MIN_SIZE : txtSize;
    el.style.fontSize = txtSize + 'px';
  }
};
