import request from '@/service/httpDecorator';
import config from '@/config';
import { saDeviceId } from '@/service/sa.service';
const { talosHost } = config;

const queryPayInfo = function(data) {
  return request.post(`${talosHost}/open/checkout`, data);
};
const prepay = async function(data) {
  const scDeviceId = await saDeviceId();
  return request.post(`${talosHost}/open/checkout/prepay`, data, {
    customHeader: {
      scDeviceId
    }
  });
};

const pay = async function(data) {
  const scDeviceId = await saDeviceId();
  return request.post(`${talosHost}/open/checkout/pay`, data, {
    customHeader: {
      scDeviceId
    }
  });
};

const queryPayStatus = function(data) {
  return request.post(`${talosHost}/open/checkout/pay_status/query`, data);
};

const sendSms = function(data) {
  return request.post(`${talosHost}/open/checkout/send_sms`, data);
};

const desSalt = function() {
  return request.get(`${talosHost}/vcc/account/salt`);
};

const h5AppyUrl = function() {
  return request.get(`${talosHost}/vcc/xyqb_mall/app_url`);
};

const getCoupon = function(params) {
  return request.post(`${talosHost}/open/checkout/pay_coupon_list`, params);
};

const ocrFaceId = function(params) {
  return request.post(`${talosHost}open/checkout/ocr_faceId`, params);
};

const getGoodsList = function(data) {
  return request.get(`${talosHost}/vcc/xyqb/recommend/goods-list`, data, {
    needScDeviceId: true,
    hideLoading: true
  });
};

// KA流程节点
const kaGetNextUrl = function() {
  return request.get(`${talosHost}/api/kdsp/ka/process/get-next-url`);
};

export {
  pay,
  prepay,
  sendSms,
  desSalt,
  h5AppyUrl,
  getCoupon,
  ocrFaceId,
  queryPayInfo,
  getGoodsList,
  kaGetNextUrl,
  queryPayStatus
};
