import Vue from 'vue';
import uiTrack from '@qg/ui-track-web';
import App from './App.vue';
import router from './router';
import store from './store';
import '@/service/svg.service';
import '@/service/cherryUI.service';
import './style/index.less';
import saService from '@/service/sa.service';
import Bridge from '@qg/js-bridge';
import Raven from 'raven-js';
import RavenVue from 'raven-js/plugins/vue';
import { release } from '../.sentryclirc';
import fontResize from './directives/fontResize';
import cfg from './config';
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Raven.config('//21779c2dcb594299bdc803c5560cfecd@sentry.q-gp.com/60', {
    release,
    environment: process.env.NODE_ENV
  })
    .addPlugin(RavenVue, Vue)
    .install();
}
Vue.prototype.util = new Bridge();
Vue.prototype.$track = new uiTrack({
  useUweb: false,
  shenceHost: cfg.shenceHost,
  showLog: cfg.test,
  router: router // router实例
});
window.Bridge = Bridge;

saService.init(router);

Vue.directive('fontResize', fontResize);
Vue.config.productionTip = false;

window.addEventListener(
  'popstate',
  () => {
    router.isBack = true;
  },
  false
);

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app');
