import Vue from 'vue';
import uiTrack from '@qg/ui-track-web';
import App from './App.vue';
import router from './router';
import store from './store';
import '@/service/svg.service';
import '@/service/cherryUI.service';
import './style/index.less';
import saService from '@/service/sa.service';
import Bridge from '@qg/js-bridge';
import { init as sentryInit } from '@sentry/vue';
import fontResize from './directives/fontResize';
import cfg from './config';
import FastClick from 'fastclick';
FastClick.attach(document.body, { tapDelay: 1 });

if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  sentryInit({
    Vue,
    dsn: 'http://d7ca98c07c6946b6b56a54b9707cb9b3@sentry.q-gp.com/15', // 项目设置中的Client Keys
    release: 'cauchy-ui@1.0.0', // 项目名加版本号
    tracesSampleRate: 0.5, // 上报频率, 1最大, 0最小, 建议验证设置为1, 项目运行根据情况降低频率
    environment: process.env.NODE_ENV
  });
}
Vue.prototype.util = new Bridge();
Vue.prototype.$track = new uiTrack({
  useUweb: false,
  shenceHost: cfg.shenceHost,
  showLog: cfg.test,
  router: router // router实例
});
window.Bridge = Bridge;

saService.init(router);

Vue.directive('fontResize', fontResize);
Vue.config.productionTip = false;

window.addEventListener(
  'popstate',
  () => {
    router.isBack = true;
  },
  false
);

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app');
