import cookies from '@/service/cookieStorage.service';
export const goUrlExtends = {
  methods: {
    goHome() {
      // 商城地址
      const returnUrl = this.getReturnUrl();
      if (returnUrl) {
        window.location.replace(`${returnUrl}`);
        return;
      }
      this.$router.replace({ name: 'home' });
    },
    goOrderList() {
      const returnUrl = this.getReturnUrl();
      if (returnUrl) {
        window.location.replace(`${returnUrl}/orderList`);
        return;
      }
      this.$router.replace({ name: 'orderList' });
    },
    goOrderDetail() {
      const returnUrl = this.getReturnUrl();
      const orderNo = cookies.get('orderNo')?.orderNo;
      if (returnUrl) {
        window.location.replace(`${returnUrl}/orderDetail?orderNo=${orderNo}`);
        return;
      }
      this.$router.push({
        name: 'orderDetail',
        query: { orderNo }
      });
    },
    getReturnUrl() {
      const returnUrl = cookies.get('returnUrl');
      return returnUrl;
    }
  }
};
