export default {
  get(key, storageType = 'localStorage') {
    let result = window[storageType].getItem(key);
    try {
      return JSON.parse(result);
    } catch (e) {
      return result;
    }
  },
  set(key, value, storageType = 'localStorage') {
    let toString = Object.prototype.toString;
    if (toString.call(value) === '[object Array]' || toString.call(value) === '[object Object]') {
      value = JSON.stringify(value);
    }
    return window[storageType].setItem(key, value);
  },
  remove(key, storageType = 'localStorage') {
    return window[storageType].removeItem(key);
  },
  clear(storageType = 'localStorage') {
    return window[storageType].clear();
  }
};
