import localStorage from '@/service/localStorage.service';
import config from '@/config/index';
const { toBHost } = config;
export const goUrlExtends = {
  methods: {
    goHome() {
      // 商城地址
      const tob = this.getTarget();
      if (tob) {
        window.location.replace = `${toBHost}`;
        return;
      }
      this.$router.replace({ name: 'home' });
    },
    goOrderList() {
      const tob = this.getTarget();
      if (tob) {
        window.location.replace = `${toBHost}/orderList`;
        return;
      }
      this.$router.replace({ name: 'orderList' }, 'sessionStorage');
    },
    goOrderDetail() {
      const tob = this.getTarget();
      const orderNo = localStorage.get('orderNo')?.orderNo;
      if (tob) {
        window.location.replace = `${toBHost}/orderDetail?orderNo=${orderNo}`;
        return;
      }
      this.$router.push({
        name: 'orderDetail',
        query: { orderNo }
      });
    },
    getTarget() {
      const tob = localStorage.get('target', 'sessionStorage');
      return tob;
    }
  }
};
