/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DataOfFetch;
import dm.jdbc.dbaccess.DmMsgRecv;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.dbaccess.Request_Response;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbLob;
import dm.jdbc.driver.DmdbLobLocator;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCache_h;
import dm.jdbc.driver.DmdbResultSetCache_v;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.innerData.DmdbExecOpt;
import dm.jdbc.xa.DmdbXAResource;
import dm.jdbc.xa.DmdbXid;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.Xid;

public class DmdbCSI {
    private static void startupServer(DmMsgSend msg, DmdbConnection_bs conn, boolean toPrimary) throws IOException, SQLException {
        Request_Response.req_startup(msg, conn, toPrimary);
        DmMsgRecv recvMsg = toPrimary ? DmdbCSI.accessToPrimary(msg, conn, 0) : DmdbCSI.accessToStandby(msg, conn, 0);
        Request_Response.resp_startup(recvMsg, conn, toPrimary);
        conn.getDbAccess().setCompress(conn.getComprMsg());
        if (conn.getEncryptMsg() == 2) {
            conn.getDbAccess().tryEnableSSL(false);
        } else if (conn.getEncryptMsg() == 1) {
            conn.getDbAccess().tryEnableSSL(true);
        } else {
            return;
        }
    }

    private static final void login(DmMsgSend msg, DmdbConnection_bs conn, boolean toPrimary) throws SQLException, IOException {
        Request_Response.req_login(msg, conn, toPrimary);
        DmMsgRecv recvMsg = toPrimary ? DmdbCSI.accessToPrimary(msg, conn, 0) : DmdbCSI.accessToStandby(msg, conn, 0);
        Request_Response.resp_login(recvMsg, conn);
    }

    public static final void connToServer(DmdbConnection_bs conn) throws SQLException, IOException {
        try {
            DmdbCSI.connToServerTry(conn, true);
            if (!conn.hasOneSvr()) {
                conn.getDbSwitch().loginSuccSwitch();
            }
        }
        catch (IOException e) {
            if (!conn.hasOneSvr()) {
                conn.getDbSwitch().loginFailedSwitch();
            }
            DBError.throwSQLException(6001);
        }
        DmdbCSI.connToStandby(conn);
    }

    public static final void connToStandby(DmdbConnection_bs conn) throws IOException, SQLException {
        if (conn.getStandbyHost() != null && conn.getStandbyHost().length() != 0) {
            conn.getDbAccess().addStandby();
            DmdbCSI.connToServerTry(conn, false);
            conn.setRwSeparate(true);
        } else {
            conn.setRwSeparate(false);
        }
    }

    public static final void connToServerTry(DmdbConnection_bs conn, boolean toPrimary) throws IOException, SQLException {
        DmMsgSend msg = new DmMsgSend();
        DmdbCSI.startupServer(msg, conn, toPrimary);
        DmdbCSI.login(msg, conn, toPrimary);
    }

    public static final int allocStmtHandle(DmdbStatement_bs stmt, DmMsgSend extMsg) throws SQLException {
        int handle = 0;
        DmdbConnection_bs conn = stmt.getConnection_bs();
        try {
            try {
                DmMsgSend msg = extMsg == null ? conn.getMsg() : extMsg;
                Request_Response.req_stmt_alloc(msg);
                DmMsgRecv recvMsg = DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
                handle = Request_Response.resp_stmt_alloc(recvMsg, stmt);
                if (conn.checkHasStandby()) {
                    DmMsgRecv recvMsgS = DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby());
                    stmt.setHandleForStandby(Request_Response.resp_stmt_alloc(recvMsgS, stmt));
                }
            }
            catch (IOException e) {
                if (conn.checkHasStandby()) {
                    conn.getDbAccess().close();
                }
                DBError.throwSQLException(6001);
                if (extMsg == null) {
                    conn.returnMsg();
                }
            }
        }
        finally {
            if (extMsg == null) {
                conn.returnMsg();
            }
        }
        return handle;
    }

    public static final DmMsgRecv sendCurPosInfo(DmdbStatement_bs stmt, long curPos) throws SQLException {
        DmMsgRecv recvMsg;
        block5: {
            DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
            recvMsg = null;
            try {
                try {
                    DmMsgSend msg = new DmMsgSend();
                    Request_Response.req_execute_sendCurInfo(false, msg, stmt, curPos);
                    recvMsg = DmdbCSI.access_server(msg, conn, stmt);
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        Request_Response.resp_execute(recvMsg, stmt);
        return recvMsg;
    }

    public static final void closeHandle(DmdbStatement_bs stmt) throws SQLException {
        DmMsgRecv recvMsg;
        DmdbConnection_bs conn;
        block7: {
            conn = (DmdbConnection_bs)stmt.getConnection();
            recvMsg = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_close_stmt(msg, stmt.getHandle());
                    recvMsg = DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
                    if (conn.checkHasStandby()) {
                        DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby());
                    }
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        if (recvMsg != null) {
            Request_Response.resp_close_stmt(recvMsg, conn);
        }
    }

    public static final void freeHandle(DmdbStatement_bs stmt) throws SQLException {
        DmMsgRecv recvMsg;
        DmdbConnection_bs conn;
        block8: {
            conn = (DmdbConnection_bs)stmt.getConnection();
            recvMsg = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_stmt_free(msg, stmt.getHandle());
                    recvMsg = DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
                    if (conn.checkHasStandby()) {
                        DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby());
                    }
                }
                catch (IOException e) {
                    if (conn.checkHasStandby()) {
                        conn.getDbAccess().close();
                    }
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        if (recvMsg != null) {
            Request_Response.resp_stmt_free(recvMsg, conn);
        }
    }

    public static final DmdbInfo prepareSQL(DmdbStatement_bs stmt, String sql, boolean direct, int checkFlag, DmMsgSend extMsg) throws SQLException {
        DmdbInfo dbInfo;
        block8: {
            DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
            DmMsgRecv recvMsg = null;
            dbInfo = null;
            try {
                try {
                    DmMsgSend msg = extMsg == null ? conn.getMsg() : extMsg;
                    Request_Response.req_prepare(msg, stmt, sql, direct, checkFlag);
                    recvMsg = DmdbCSI.access_server(msg, conn, stmt);
                    boolean fromStandby = recvMsg.getFromStandby();
                    stmt.setFromStandby(fromStandby);
                    dbInfo = Request_Response.resp_prepare(recvMsg, conn.getServerEncoding(), stmt, direct);
                    if (!dbInfo.getSavepointFlag() || !conn.checkHasStandby()) break block8;
                    if (fromStandby) {
                        recvMsg = DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
                        break block8;
                    }
                    recvMsg = DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby());
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    if (extMsg == null) {
                        conn.returnMsg();
                    }
                }
            }
            finally {
                if (extMsg == null) {
                    conn.returnMsg();
                }
            }
        }
        return dbInfo;
    }

    public static final DmdbInfo prepareSQLForRe(DmdbStatement_bs stmt, String sql, boolean direct, int checkFlag, DmMsgSend msg, boolean toStandby) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recvMsg = null;
        try {
            Request_Response.req_prepare(msg, stmt, sql, direct, checkFlag);
            recvMsg = toStandby ? DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby()) : DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
        }
        catch (IOException e) {
            DBError.throwSQLException(6001);
        }
        return Request_Response.resp_prepare(recvMsg, conn.getServerEncoding(), stmt, direct);
    }

    public static final DmdbInfo directExec_Opt(DmdbStatement_bs stmt, DmdbExecOpt execOpt) throws SQLException {
        DmdbInfo dbInfo;
        DmMsgRecv recv;
        block8: {
            DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
            recv = null;
            dbInfo = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_exec_direct(msg, stmt, execOpt);
                    recv = DmdbCSI.access_server(msg, conn, stmt);
                    dbInfo = Request_Response.resp_exec_direct(recv, stmt);
                    if (dbInfo.getSavepointFlag() && conn.checkHasStandby()) {
                        if (recv.getFromStandby()) {
                            DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
                        } else {
                            DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby());
                        }
                    }
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        stmt.setFromStandby(recv.getFromStandby());
        return dbInfo;
    }

    public static final void commitWork(DmdbConnection_bs conn, int holdability) throws SQLException {
        DmMsgRecv recvMsg;
        block7: {
            recvMsg = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_commit(msg);
                    recvMsg = DmdbCSI.accessToPrimary(msg, conn, 0);
                    if (conn.checkHasStandby()) {
                        DmdbCSI.accessToStandby(msg, conn, 0);
                    }
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        int sqlcode = Request_Response.resp_commit(recvMsg, conn);
        if (sqlcode >= 0 && holdability == 2) {
            conn.close_all_resultSet();
        }
    }

    public static final void rollbackWork(DmdbConnection_bs conn, int holdability) throws SQLException {
        DmMsgRecv recvMsg;
        block7: {
            recvMsg = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_rollback(msg);
                    recvMsg = DmdbCSI.accessToPrimary(msg, conn, 0);
                    if (conn.checkHasStandby()) {
                        DmdbCSI.accessToStandby(msg, conn, 0);
                    }
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        int sqlcode = Request_Response.resp_rollback(recvMsg, conn);
        if (sqlcode >= 0 && holdability == 2) {
            conn.close_all_resultSet();
        }
    }

    private static void setParasMsg(boolean preExeced, DmMsgSend msg, DmdbStatement_bs stmt, int irow) throws SQLException {
        Request_Response.req_execute(preExeced, msg, stmt, stmt.cursorUpdateRow, irow);
    }

    private static int setBatchParasMsg(boolean preExeced, int startRow, DmMsgSend msg, DmdbPreparedStatement_bs stmt) throws SQLException {
        return Request_Response.req_execute_for_batch(preExeced, startRow, msg, stmt);
    }

    public static final DmdbInfo executePrepared(DmdbStatement_bs stmt, int irow) throws SQLException {
        return DmdbCSI.executePrepared(false, stmt, irow, null);
    }

    private static final DmdbInfo executePrepared(boolean preExeced, DmdbStatement_bs stmt, int irow, DmMsgSend sendMsg) throws SQLException {
        DmdbInfo dbInfo;
        DmMsgRecv recv;
        block16: {
            DmdbConnection_bs conn;
            block15: {
                conn = (DmdbConnection_bs)stmt.getConnection();
                recv = null;
                dbInfo = null;
                boolean fromStandby = stmt.getFromStandby();
                DmMsgSend msg = null;
                try {
                    try {
                        msg = sendMsg == null ? conn.getMsg() : sendMsg;
                        DmdbCSI.setParasMsg(preExeced, msg, stmt, irow);
                        recv = DmdbCSI.access_server(msg, conn, stmt);
                        stmt.setPutLobData(1);
                        try {
                            dbInfo = DmdbCSI.getDescAndResultSet(stmt, recv);
                            if (dbInfo.getSavepointFlag() && conn.checkHasStandby()) {
                                if (recv.getFromStandby()) {
                                    DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
                                } else {
                                    DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby());
                                }
                            }
                        }
                        catch (SQLException ex) {
                            if (ex.getErrorCode() == -2002 && conn.checkHasStandby()) {
                                DmdbCSI.prepareSQLForRe(stmt, stmt.originalSql, false, 0, msg, !fromStandby);
                                DmdbCSI.setParasMsg(preExeced, msg, stmt, irow);
                                try {
                                    recv = DmdbCSI.access_server(msg, conn, stmt);
                                }
                                catch (IOException e) {
                                    DBError.throwSQLException(6001);
                                }
                                dbInfo = DmdbCSI.getDescAndResultSet(stmt, recv);
                                break block15;
                            }
                            throw ex;
                        }
                    }
                    catch (IOException e) {
                        DBError.throwSQLException(6001);
                        if (sendMsg == null) {
                            conn.returnMsg();
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (sendMsg == null) {
                        conn.returnMsg();
                    }
                    throw throwable;
                }
            }
            if (sendMsg == null) {
                conn.returnMsg();
            }
        }
        stmt.setFromStandby(recv.getFromStandby());
        return dbInfo;
    }

    public static final int[] executePreparedBatch(DmdbPreparedStatement_bs stmt) throws SQLException {
        DmMsgRecv recv;
        int[] retArr;
        block9: {
            DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
            int batchSize = stmt.getBatchSize();
            retArr = new int[batchSize];
            int[] retTmp = null;
            boolean preExeced = false;
            recv = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    int startRow = 0;
                    int nextRow = 0;
                    while (startRow < batchSize) {
                        nextRow = DmdbCSI.setBatchParasMsg(preExeced, startRow, msg, stmt);
                        if (nextRow != startRow && (retTmp = DmdbCSI.getBatchRowCounts(recv = DmdbCSI.access_server(msg, conn, stmt), stmt)) != null) {
                            System.arraycopy(retTmp, 0, retArr, startRow, nextRow - startRow);
                        }
                        if (nextRow != batchSize) {
                            DmdbInfo retdbInfo = DmdbCSI.executePrepared(preExeced, stmt, nextRow, msg);
                            preExeced = true;
                            retArr[nextRow] = retdbInfo.getRowCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)retdbInfo.getRowCount();
                            startRow = nextRow + 1;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        if (recv != null) {
            stmt.setFromStandby(recv.getFromStandby());
        }
        return retArr;
    }

    public static final DmdbInfo getMoreResult(DmdbStatement_bs stmt, short resId) throws SQLException {
        DmMsgRecv recv;
        block5: {
            DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
            recv = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_more_result(msg, stmt.getHandle(), resId);
                    recv = stmt.getFromStandby() ? DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby()) : DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        return DmdbCSI.getDescAndResultSet(stmt, recv);
    }

    private static DmdbInfo getDescAndResultSet(DmdbStatement_bs stmt, DmMsgRecv recv) throws SQLException {
        return Request_Response.resp_execute(recv, stmt);
    }

    public static final void putBlobData(DmdbPreparedStatement_bs stmt, int irow, int paramIndex, DmBinder binder) throws SQLException {
        DmMsgSend blobMsg = new DmMsgSend();
        int retLen = 0;
        while (true) {
            blobMsg.resetCurNode();
            retLen = binder.bindLobCyc(blobMsg, irow, paramIndex);
            if (retLen == 0) break;
            DmdbCSI.putData(stmt, blobMsg, paramIndex, retLen);
        }
    }

    private static final void putData(DmdbStatement_bs stmt, DmMsgSend blobMsg, int paramIndex, int len) throws SQLException {
        DmMsgRecv recvMsg = null;
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        try {
            Request_Response.req_put_data(stmt.getHandle(), blobMsg, paramIndex, len);
            recvMsg = DmdbCSI.access_server(blobMsg, conn, stmt);
        }
        catch (IOException e) {
            DBError.throwSQLException(6001);
        }
        Request_Response.resp_put_data(recvMsg, conn);
    }

    public static final byte[] getBlobData(DmdbStatement_bs stmt, DmdbConnection_bs conn, DmdbLobLocator lobLocator, boolean fromStandby) throws SQLException {
        int cntHasGet;
        Vector<byte[]> vec;
        block7: {
            vec = new Vector<byte[]>(10);
            boolean isOver = false;
            DmMsgRecv recvMsg = null;
            cntHasGet = 0;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    while (!isOver) {
                        Request_Response.req_get_data(msg, stmt.getHandle(), cntHasGet, lobLocator);
                        recvMsg = DmdbCSI.access_server(msg, conn, stmt);
                        isOver = Request_Response.resp_get_data(recvMsg, conn, lobLocator, cntHasGet);
                        vec.add(lobLocator.m_dataOnceGet);
                        cntHasGet += lobLocator.m_dataOnceGet.length;
                    }
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        byte[] retData = new byte[cntHasGet];
        int tmp = 0;
        byte[] aBlockData = null;
        int i = 0;
        while (i < vec.size()) {
            aBlockData = (byte[])vec.get(i);
            System.arraycopy(aBlockData, 0, retData, tmp, aBlockData.length);
            tmp += aBlockData.length;
            ++i;
        }
        return retData;
    }

    public static final int fetch(DmdbStatement_bs stmt, long curPos, boolean fetchAll, DmdbResultSet_bs resultSet, short resId, boolean fromStandby) throws SQLException {
        byte[] buf;
        DataOfFetch dataOfFetch;
        int sqlcode;
        block19: {
            sqlcode = 0;
            DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
            dataOfFetch = new DataOfFetch(Long.MAX_VALUE, curPos, resId);
            DmMsgRecv recvMsg = null;
            buf = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    while (true) {
                        Request_Response.req_fetch(msg, stmt.getHandle(), dataOfFetch);
                        recvMsg = fromStandby ? DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby()) : DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
                        sqlcode = Request_Response.resp_fetch_checkErr(recvMsg, conn);
                        if (sqlcode == -7036) {
                            if (resultSet != null) {
                                resultSet.rowCount = recvMsg.res_fetch_get_row_count();
                            }
                        } else {
                            buf = Request_Response.resp_fetch_without_checkErr(recvMsg, dataOfFetch, resultSet, buf, true);
                            if (resultSet == null || resultSet.rowCount <= 0L || !(!fetchAll ? (long)dataOfFetch.getResRowCnt_get() == resultSet.rowCount : (long)(resultSet.rsCache.rownum + dataOfFetch.getResRowCnt_get()) == resultSet.rowCount)) {
                                if (sqlcode == 100) {
                                    if (resultSet != null && resultSet.rowCount == Long.MAX_VALUE) {
                                        resultSet.rowCount = dataOfFetch.getCurPos();
                                    }
                                } else if (fetchAll) {
                                    if (buf == null) continue;
                                    resultSet.rsCache.addBuffer(buf, (int)dataOfFetch.getMsglen_total(), dataOfFetch.getResRowCnt_get());
                                    continue;
                                }
                            }
                        }
                        break;
                    }
                }
                catch (IOException ioex) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block19;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        if (buf != null) {
            if (fetchAll) {
                resultSet.rsCache.addBuffer(buf, (int)dataOfFetch.getMsglen_total(), dataOfFetch.getResRowCnt_get());
            } else if (resultSet.multiRsCaches()) {
                DmdbResultSetCache tmp = stmt.getDmdbInfo().isBdtaRs() ? new DmdbResultSetCache_v(resultSet.rsCache.statement, resultSet.rsCache.cols, -1) : new DmdbResultSetCache_h(resultSet.rsCache.statement, resultSet.rsCache.cols);
                tmp.fillBuffer(buf, (int)dataOfFetch.getMsglen_total(), dataOfFetch.getResRowCnt_get());
                resultSet.addRsCache(tmp);
            } else {
                resultSet.rsCache.fillBuffer(buf, (int)dataOfFetch.getMsglen_total(), dataOfFetch.getResRowCnt_get());
            }
        }
        return sqlcode;
    }

    static final void setCursorName(DmdbStatement_bs stmt, String cursorName) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        DmMsgRecv recvMsg = null;
        DmMsgRecv recvMsgS = null;
        try {
            try {
                DmMsgSend msg = conn.getMsg();
                Request_Response.req_cursor_set_name(msg, conn.getServerEncoding(), stmt.getHandle(), cursorName);
                recvMsg = DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
                Request_Response.resp_cursor_set_name(recvMsg, conn);
                if (conn.checkHasStandby() && (recvMsgS = DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby())) != null) {
                    Request_Response.resp_cursor_set_name(recvMsg, conn);
                }
            }
            catch (IOException ioex) {
                if (conn.checkHasStandby()) {
                    conn.getDbAccess().close();
                }
                DBError.throwSQLException(6001);
                conn.returnMsg();
            }
        }
        finally {
            conn.returnMsg();
        }
    }

    public static final String getExplainInfo(DmdbStatement_bs stmt, String sqlToExplain) throws SQLException {
        DmMsgRecv recvMsg;
        String serverEncoding;
        block7: {
            if (sqlToExplain == null || sqlToExplain.trim().length() == 0) {
                DBError.throwSQLException(6003);
            }
            if (!sqlToExplain.equalsIgnoreCase("show_pln_stat")) {
                sqlToExplain = "EXPLAIN " + sqlToExplain;
            }
            DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
            serverEncoding = conn.getServerEncoding();
            recvMsg = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_prepare(msg, stmt, sqlToExplain, true, 0);
                    recvMsg = DmdbCSI.access_server(msg, conn, stmt);
                }
                catch (IOException ioex) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        DmdbInfo des = Request_Response.resp_prepare(recvMsg, serverEncoding, stmt, true);
        return des.getExplain();
    }

    public static final long blob_text_truncate(DmdbLob lob, byte flag, int length, boolean fromStandby) throws SQLException {
        DmMsgRecv recv;
        block5: {
            DmdbConnection_bs conn = lob.getConnection();
            recv = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_lob_truncate(msg, lob.getLobLocator(), length);
                    recv = DmdbCSI.access_server(msg, lob.getConnection(), null);
                }
                catch (IOException ioex) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        return Request_Response.resp_lob_truncate(recv, lob.getLobLocator(), lob.getConnection());
    }

    public static final long lob_get_len(DmdbLob lob, boolean fromStandby) throws SQLException {
        DmMsgSend lobMsg = new DmMsgSend();
        DmMsgRecv recv = null;
        try {
            Request_Response.req_get_lob_len(lobMsg, lob.getLobLocator());
            recv = DmdbCSI.access_server(lobMsg, lob.getConnection(), null);
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        return Request_Response.resp_get_lob_len(recv, lob);
    }

    public static final byte[] lob_get_bytes(DmdbLob lob, byte flag, int start_pos, int length, boolean fromStandby) throws SQLException {
        DmMsgSend blobMsg = new DmMsgSend();
        DmMsgRecv recv = null;
        try {
            Request_Response.req_get_lob_data(blobMsg, lob.getLobLocator(), start_pos, length);
            recv = DmdbCSI.access_server(blobMsg, lob.getConnection(), null);
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        return Request_Response.resp_get_lob_data(recv, lob.getLobLocator(), lob.getConnection());
    }

    public static final int lob_set_bytes(DmdbLob lob, byte flag, int start_pos, byte[] buf, int off, int len, byte firstOrLast, boolean fromStandby) throws SQLException {
        DmMsgRecv recv;
        block5: {
            recv = null;
            try {
                try {
                    DmMsgSend msg = lob.getConnection().getMsg();
                    Request_Response.req_set_lob_data(msg, lob.getLobLocator(), start_pos, buf, off, len, firstOrLast);
                    recv = DmdbCSI.access_server(msg, lob.getConnection(), null);
                }
                catch (IOException ioex) {
                    DBError.throwSQLException(6001);
                    lob.getConnection().returnMsg();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                lob.getConnection().returnMsg();
                throw throwable;
            }
            lob.getConnection().returnMsg();
        }
        return Request_Response.resp_set_lob_data(recv, lob.getLobLocator(), lob.getConnection());
    }

    public static final String text_get_subString(DmdbLob lob, byte flag, int pos, int len, boolean fromStandby) throws SQLException {
        String str = null;
        byte[] bs = DmdbCSI.lob_get_bytes(lob, flag, pos, len, fromStandby);
        try {
            String serverEncoding = lob.getConnection().getServerEncoding();
            if (bs != null) {
                str = new String(bs, serverEncoding);
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return str;
    }

    private static int[] getBatchRowCounts(DmMsgRecv recv, DmdbStatement_bs stmt) throws SQLException {
        return Request_Response.resp_execute_for_batch(recv, stmt);
    }

    public static final long getRowCount(DmdbStatement_bs stmt, boolean fromStandby) throws SQLException {
        DmMsgRecv recvMsg;
        DataOfFetch dataFetch;
        DmdbConnection_bs conn;
        block5: {
            conn = (DmdbConnection_bs)stmt.getConnection();
            dataFetch = new DataOfFetch(1L, Long.MAX_VALUE, 0);
            recvMsg = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_fetch(msg, stmt.handle, dataFetch);
                    recvMsg = fromStandby ? DmdbCSI.accessToStandby(msg, conn, stmt.getHandleForStandby()) : DmdbCSI.accessToPrimary(msg, conn, stmt.getHandle());
                }
                catch (IOException ioex) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        Request_Response.resp_fetch_checkErr(recvMsg, conn);
        Request_Response.resp_fetch_without_checkErr(recvMsg, dataFetch, null, null, false);
        return dataFetch.getResRowCnt_total();
    }

    public static final void preExec(DmdbStatement_bs stmt, int irow, DmBinder[] binders, boolean forBatch) throws SQLException {
        DmMsgSend blobMsg = new DmMsgSend();
        DmMsgRecv recvMsg = null;
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        try {
            Request_Response.req_pre_exec(stmt.getHandle(), blobMsg, irow, binders, forBatch);
            recvMsg = DmdbCSI.access_server(blobMsg, conn, stmt);
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        Request_Response.resp_pre_exec(recvMsg, conn);
    }

    static final void setSessionIsoLevel(int isoLevel, DmdbConnection_bs conn) throws SQLException {
        DmMsgRecv recv = null;
        try {
            try {
                DmMsgSend msg = conn.getMsg();
                Request_Response.req_sess_iso(msg, isoLevel);
                recv = DmdbCSI.accessToPrimary(msg, conn, 0);
                Request_Response.resp_sess_iso(recv, conn);
                if (conn.checkHasStandby()) {
                    DmdbCSI.accessToStandby(msg, conn, 0);
                }
            }
            catch (IOException ioex) {
                if (conn.checkHasStandby()) {
                    conn.getDbAccess().close();
                }
                DBError.throwSQLException(6001);
                conn.returnMsg();
            }
        }
        finally {
            conn.returnMsg();
        }
    }

    public static final long[] table_ts(DmdbConnection_bs conn, long[] tbIds) throws SQLException {
        DmMsgRecv recv;
        block5: {
            recv = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_table_ts(msg, tbIds);
                    recv = DmdbCSI.access_server(msg, conn, null);
                }
                catch (IOException ioex) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        return Request_Response.resp_table_ts(recv, conn);
    }

    private static final boolean access_with_switch_need(DmdbConnection_bs conn, DmMsgRecv recvMsg) {
        short retType = Request_Response.resp_ret_type(recvMsg);
        short svrMode = Request_Response.resp_svr_mode(recvMsg);
        if (228 == retType || 163 == retType) {
            return false;
        }
        return 2 == svrMode && 1 == conn.getSvrMode();
    }

    private static final DmMsgRecv access_with_switch(DmMsgSend sendMsg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException {
        DmMsgRecv retMsg = null;
        try {
            try {
                retMsg = DmdbCSI.access_without_switch(sendMsg, conn, stmt);
            }
            catch (IOException e) {
                conn.getDbSwitch().doSwitch();
                DBError.throwSQLException(20000);
            }
            if (DmdbCSI.access_with_switch_need(conn, retMsg)) {
                conn.getDbSwitch().doSwitch();
                DBError.throwSQLException(20000);
            }
        }
        catch (IOException ex) {
            DBError.throwSQLException(20001);
        }
        return retMsg;
    }

    private static final DmMsgRecv access_without_switch(DmMsgSend sendMsg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException, IOException {
        if (stmt == null) {
            return conn.getDbAccess().access(sendMsg, 0, 0);
        }
        return conn.getDbAccess().access(sendMsg, stmt.getHandle(), stmt.getHandleForStandby());
    }

    private static final DmMsgRecv accessToStandby(DmMsgSend sendMsg, DmdbConnection_bs conn, int handleForStandby) throws SQLException, IOException {
        if (!conn.hasOneSvr() && conn.doSwitch()) {
            DmMsgRecv retMsg = null;
            try {
                retMsg = conn.getDbAccess().accessStandby(sendMsg, handleForStandby);
            }
            catch (IOException e) {
                conn.getDbSwitch().doSwitch();
                DBError.throwSQLException(20000);
            }
            return retMsg;
        }
        return conn.getDbAccess().accessStandby(sendMsg, handleForStandby);
    }

    private static final DmMsgRecv accessToPrimary(DmMsgSend sendMsg, DmdbConnection_bs conn, int handle) throws SQLException, IOException {
        if (!conn.hasOneSvr() && conn.doSwitch()) {
            DmMsgRecv retMsg = null;
            try {
                try {
                    retMsg = conn.getDbAccess().accessPrimary(sendMsg, handle);
                }
                catch (IOException e) {
                    conn.getDbSwitch().doSwitch();
                    DBError.throwSQLException(20000);
                }
                if (DmdbCSI.access_with_switch_need(conn, retMsg)) {
                    conn.getDbSwitch().doSwitch();
                    DBError.throwSQLException(20000);
                }
            }
            catch (IOException ex) {
                DBError.throwSQLException(20001);
            }
            return retMsg;
        }
        return conn.getDbAccess().accessPrimary(sendMsg, handle);
    }

    private static final DmMsgRecv access_server(DmMsgSend sendMsg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException, IOException {
        if (!conn.hasOneSvr() && conn.doSwitch()) {
            return DmdbCSI.access_with_switch(sendMsg, conn, stmt);
        }
        return DmdbCSI.access_without_switch(sendMsg, conn, stmt);
    }

    public static final synchronized int xa_process(DmdbConnection_bs conn, int xa_type, Xid xid, int flag) throws Exception {
        DmMsgRecv recvMsg;
        block5: {
            recvMsg = null;
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_xa_common(msg, xa_type, xid, flag);
                    recvMsg = DmdbCSI.access_server(msg, conn, null);
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        return Request_Response.resp_xa_common(recvMsg);
    }

    public static final synchronized DmdbXid[] xa_recover(DmdbXAResource xaResource, int flag) throws Exception {
        DmMsgRecv recvMsg;
        block5: {
            recvMsg = null;
            DmdbConnection_bs conn = (DmdbConnection_bs)xaResource.getConnection();
            try {
                try {
                    DmMsgSend msg = conn.getMsg();
                    Request_Response.req_xa_common(msg, 5, null, flag);
                    recvMsg = DmdbCSI.access_server(msg, conn, null);
                }
                catch (IOException e) {
                    DBError.throwSQLException(6001);
                    conn.returnMsg();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                conn.returnMsg();
                throw throwable;
            }
            conn.returnMsg();
        }
        return Request_Response.resp_xa_recover(xaResource, recvMsg);
    }
}

