/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.error.RuntimeErrors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.BatchContextImpl;
import sqlj.runtime.profile.ref.RTResultSetJDBC;
import sqlj.runtime.profile.ref.RTStatementJDBCPrepared;

public class RTStatementJDBCBase {
    protected PreparedStatement preparedStmt;
    private boolean m_executeComplete = false;
    private RTResultSetJDBC m_openResultSet = null;
    private boolean m_isClosed = false;
    private BatchContextImpl m_batchContext;
    private EntryInfo m_entryInfo;
    protected int[] m_indicatorArray = null;

    public RTStatementJDBCBase(PreparedStatement preparedStatement) {
        this.preparedStmt = preparedStatement;
    }

    public PreparedStatement getJDBCPreparedStatement() {
        return this.preparedStmt;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.preparedStmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        this.preparedStmt.setMaxFieldSize(n2);
    }

    public int getMaxRows() throws SQLException {
        return this.preparedStmt.getMaxRows();
    }

    public void setMaxRows(int n2) throws SQLException {
        this.preparedStmt.setMaxRows(n2);
    }

    public int getQueryTimeout() throws SQLException {
        return this.preparedStmt.getQueryTimeout();
    }

    public void setQueryTimeout(int n2) throws SQLException {
        this.preparedStmt.setQueryTimeout(n2);
    }

    public void cancel() throws SQLException {
        this.preparedStmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.preparedStmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.preparedStmt.clearWarnings();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.m_openResultSet != null) {
            this.m_openResultSet.close();
            this.m_openResultSet = null;
        }
        return this.preparedStmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.preparedStmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.preparedStmt.getMoreResults();
    }

    public boolean getMoreResults(int n2) throws SQLException {
        return this.preparedStmt.getMoreResults(n2);
    }

    public RTResultSet executeRTQuery() throws SQLException {
        RTResultSetJDBC rTResultSetJDBC;
        this.m_openResultSet = rTResultSetJDBC = new RTResultSetJDBC(this.preparedStmt.executeQuery(), this);
        return rTResultSetJDBC;
    }

    public int executeUpdate() throws SQLException {
        if (this.m_batchContext != null) {
            this.preparedStmt.addBatch();
            return 0;
        }
        return this.preparedStmt.executeUpdate();
    }

    public void setBoolean(int n2, boolean bl2) throws SQLException {
        this.preparedStmt.setBoolean(n2, bl2);
    }

    public void setBoolean(int n2, boolean bl2, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -7)) {
            return;
        }
        this.preparedStmt.setBoolean(n2, bl2);
    }

    public void setByte(int n2, byte by) throws SQLException {
        this.preparedStmt.setByte(n2, by);
    }

    public void setByte(int n2, byte by, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -6)) {
            return;
        }
        this.preparedStmt.setByte(n2, by);
    }

    public void setShort(int n2, short s2) throws SQLException {
        this.preparedStmt.setShort(n2, s2);
    }

    public void setShort(int n2, short s2, short s3) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s3, 5)) {
            return;
        }
        this.preparedStmt.setShort(n2, s2);
    }

    public void setInt(int n2, int n3) throws SQLException {
        this.preparedStmt.setInt(n2, n3);
    }

    public void setInt(int n2, int n3, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 4)) {
            return;
        }
        this.preparedStmt.setInt(n2, n3);
    }

    public void setLong(int n2, long l2) throws SQLException {
        this.preparedStmt.setLong(n2, l2);
    }

    public void setLong(int n2, long l2, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -5)) {
            return;
        }
        this.preparedStmt.setLong(n2, l2);
    }

    public void setFloat(int n2, float f2) throws SQLException {
        this.preparedStmt.setFloat(n2, f2);
    }

    public void setFloat(int n2, float f2, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 7)) {
            return;
        }
        this.preparedStmt.setFloat(n2, f2);
    }

    public void setDouble(int n2, double d2) throws SQLException {
        this.preparedStmt.setDouble(n2, d2);
    }

    public void setDouble(int n2, double d2, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 8)) {
            return;
        }
        this.preparedStmt.setDouble(n2, d2);
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.preparedStmt.setBigDecimal(n2, bigDecimal);
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 2)) {
            return;
        }
        this.preparedStmt.setBigDecimal(n2, bigDecimal);
    }

    public void setString(int n2, String string) throws SQLException {
        this.preparedStmt.setString(n2, string);
    }

    public void setString(int n2, String string, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 12)) {
            return;
        }
        this.preparedStmt.setString(n2, string);
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.preparedStmt.setBytes(n2, byArray);
    }

    public void setBytes(int n2, byte[] byArray, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -3)) {
            return;
        }
        this.preparedStmt.setBytes(n2, byArray);
    }

    public void setDate(int n2, Date date) throws SQLException {
        this.preparedStmt.setDate(n2, date);
    }

    public void setDate(int n2, Date date, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 91)) {
            return;
        }
        this.preparedStmt.setDate(n2, date);
    }

    public void setTime(int n2, Time time) throws SQLException {
        this.preparedStmt.setTime(n2, time);
    }

    public void setTime(int n2, Time time, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 92)) {
            return;
        }
        this.preparedStmt.setTime(n2, time);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.preparedStmt.setTimestamp(n2, timestamp);
    }

    public void setTimestamp(int n2, Timestamp timestamp, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 93)) {
            return;
        }
        this.preparedStmt.setTimestamp(n2, timestamp);
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.preparedStmt.setObject(n2, object);
    }

    public void setObject(int n2, Object object, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 1111)) {
            return;
        }
        this.preparedStmt.setObject(n2, object);
    }

    public boolean execute() throws SQLException {
        if (this.m_batchContext != null) {
            this.preparedStmt.addBatch();
            return false;
        }
        return this.preparedStmt.execute();
    }

    public void executeComplete() throws SQLException {
        this.m_executeComplete = true;
        this.checkClose();
        this.m_indicatorArray = null;
    }

    void notifyClosed(RTResultSetJDBC rTResultSetJDBC) throws SQLException {
        this.m_openResultSet = null;
        this.checkClose();
    }

    private void checkClose() throws SQLException {
        if (!this.m_isClosed && this.m_executeComplete && this.m_openResultSet == null) {
            this.m_isClosed = true;
            if (this.m_batchContext == null) {
                this.preparedStmt.close();
            }
        }
    }

    public void setBooleanWrapper(int n2, Boolean bl2) throws SQLException {
        if (bl2 == null) {
            this.preparedStmt.setNull(n2, -7);
        } else {
            this.preparedStmt.setBoolean(n2, bl2);
        }
    }

    public void setBooleanWrapper(int n2, Boolean bl2, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -7)) {
            return;
        }
        this.setBooleanWrapper(n2, bl2);
    }

    public void setByteWrapper(int n2, Byte by) throws SQLException {
        if (by == null) {
            this.preparedStmt.setNull(n2, -6);
        } else {
            this.preparedStmt.setByte(n2, by);
        }
    }

    public void setByteWrapper(int n2, Byte by, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -6)) {
            return;
        }
        this.setByteWrapper(n2, by);
    }

    public void setShortWrapper(int n2, Short s2) throws SQLException {
        if (s2 == null) {
            this.preparedStmt.setNull(n2, 5);
        } else {
            this.preparedStmt.setShort(n2, s2);
        }
    }

    public void setShortWrapper(int n2, Short s2, short s3) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s3, 5)) {
            return;
        }
        this.setShortWrapper(n2, s2);
    }

    public void setIntWrapper(int n2, Integer n3) throws SQLException {
        if (n3 == null) {
            this.preparedStmt.setNull(n2, 4);
        } else {
            this.preparedStmt.setInt(n2, n3);
        }
    }

    public void setIntWrapper(int n2, Integer n3, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 4)) {
            return;
        }
        this.setIntWrapper(n2, n3);
    }

    public void setLongWrapper(int n2, Long l2) throws SQLException {
        if (l2 == null) {
            this.preparedStmt.setNull(n2, -5);
        } else {
            this.preparedStmt.setLong(n2, l2);
        }
    }

    public void setLongWrapper(int n2, Long l2, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -5)) {
            return;
        }
        this.setLongWrapper(n2, l2);
    }

    public void setFloatWrapper(int n2, Float f2) throws SQLException {
        if (f2 == null) {
            this.preparedStmt.setNull(n2, 7);
        } else {
            this.preparedStmt.setFloat(n2, f2.floatValue());
        }
    }

    public void setFloatWrapper(int n2, Float f2, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 7)) {
            return;
        }
        this.setFloatWrapper(n2, f2);
    }

    public void setDoubleWrapper(int n2, Double d2) throws SQLException {
        if (d2 == null) {
            this.preparedStmt.setNull(n2, 8);
        } else {
            this.preparedStmt.setDouble(n2, d2);
        }
    }

    public void setDoubleWrapper(int n2, Double d2, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 8)) {
            return;
        }
        this.setDoubleWrapper(n2, d2);
    }

    public void setAsciiStreamWrapper(int n2, AsciiStream asciiStream) throws SQLException {
        if (asciiStream == null) {
            this.preparedStmt.setNull(n2, -1);
        } else {
            this.preparedStmt.setAsciiStream(n2, asciiStream.getInputStream(), asciiStream.getLength());
        }
    }

    public void setAsciiStreamWrapper(int n2, AsciiStream asciiStream, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -1)) {
            return;
        }
        this.setAsciiStreamWrapper(n2, asciiStream);
    }

    public void setCharacterStreamWrapper(int n2, CharacterStream characterStream) throws SQLException {
        if (characterStream == null) {
            this.preparedStmt.setNull(n2, -1);
        } else {
            this.preparedStmt.setCharacterStream(n2, characterStream.getReader(), characterStream.getLength());
        }
    }

    public void setCharacterStreamWrapper(int n2, CharacterStream characterStream, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -1)) {
            return;
        }
        this.setCharacterStreamWrapper(n2, characterStream);
    }

    public void setBinaryStreamWrapper(int n2, BinaryStream binaryStream) throws SQLException {
        if (binaryStream == null) {
            this.preparedStmt.setNull(n2, -4);
        } else {
            this.preparedStmt.setBinaryStream(n2, binaryStream.getInputStream(), binaryStream.getLength());
        }
    }

    public void setBinaryStreamWrapper(int n2, BinaryStream binaryStream, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -4)) {
            return;
        }
        this.setBinaryStreamWrapper(n2, binaryStream);
    }

    public void setUnicodeStreamWrapper(int n2, UnicodeStream unicodeStream) throws SQLException {
        if (unicodeStream == null) {
            this.preparedStmt.setNull(n2, -1);
        } else {
            this.preparedStmt.setUnicodeStream(n2, unicodeStream.getInputStream(), unicodeStream.getLength());
        }
    }

    public void setUnicodeStreamWrapper(int n2, UnicodeStream unicodeStream, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -1)) {
            return;
        }
        this.setUnicodeStreamWrapper(n2, unicodeStream);
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        this.preparedStmt.setBlob(n2, blob);
    }

    public void setBlob(int n2, Blob blob, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 2004)) {
            return;
        }
        this.preparedStmt.setBlob(n2, blob);
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        this.preparedStmt.setClob(n2, clob);
    }

    public void setClob(int n2, Clob clob, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 2005)) {
            return;
        }
        this.preparedStmt.setClob(n2, clob);
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        this.preparedStmt.setRef(n2, ref);
    }

    public void setRef(int n2, Ref ref, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 2006)) {
            return;
        }
        this.preparedStmt.setRef(n2, ref);
    }

    public void setArray(int n2, Array array) throws SQLException {
        this.preparedStmt.setArray(n2, array);
    }

    public void setArray(int n2, Array array, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 2003)) {
            return;
        }
        this.preparedStmt.setArray(n2, array);
    }

    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.preparedStmt.setSQLXML(n2, sQLXML);
    }

    public void setSQLXML(int n2, SQLXML sQLXML, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, 2009)) {
            return;
        }
        this.preparedStmt.setSQLXML(n2, sQLXML);
    }

    public void setRowId(int n2, RowId rowId) throws SQLException {
        this.preparedStmt.setRowId(n2, rowId);
    }

    public void setRowId(int n2, RowId rowId, short s2) throws SQLException {
        if (this.checkAndSetInputIndicator(n2, s2, -8)) {
            return;
        }
        this.preparedStmt.setRowId(n2, rowId);
    }

    protected void setBatchContext(BatchContextImpl batchContextImpl) {
        this.m_batchContext = batchContextImpl;
    }

    protected void setEntryInfo(EntryInfo entryInfo) {
        this.m_entryInfo = entryInfo;
    }

    protected EntryInfo getEntryInfoObject() {
        return this.m_entryInfo;
    }

    public boolean isBatchable() throws SQLException {
        if (this.m_entryInfo == null || this.m_entryInfo.getRole() != 3 || this.m_entryInfo.getStatementType() != 2 || this.m_entryInfo.getExecuteType() == 16 || this.m_entryInfo.getResultSetType() != 128) {
            this.m_batchContext = null;
            return false;
        }
        return true;
    }

    public BatchContext getBatchContext() throws SQLException {
        this.m_batchContext = new BatchContextImpl((RTStatement)((Object)this));
        return this.m_batchContext;
    }

    public boolean isBatchCompatible() throws SQLException {
        RTStatementJDBCPrepared rTStatementJDBCPrepared = (RTStatementJDBCPrepared)this.m_batchContext.getRTStatement();
        EntryInfo entryInfo = rTStatementJDBCPrepared.getEntryInfoObject();
        int n2 = entryInfo.getParamCount();
        if (n2 != this.m_entryInfo.getParamCount()) {
            return false;
        }
        for (int i2 = 1; i2 <= n2; ++i2) {
            if (entryInfo.getParamInfo(i2).getSQLType() == this.m_entryInfo.getParamInfo(i2).getSQLType()) continue;
            return false;
        }
        if (RTStatementJDBCBase.compareSQLStrings(entryInfo.getSQLString(), this.m_entryInfo.getSQLString()) != 0) {
            return false;
        }
        this.preparedStmt.close();
        this.preparedStmt = this.m_batchContext.getPreparedStatement();
        return true;
    }

    protected static int compareSQLStrings(String string, String string2) {
        String string3 = RTStatementJDBCBase.substitute(RTStatementJDBCBase.substitute(string, "", " "), "", "\t");
        String string4 = RTStatementJDBCBase.substitute(RTStatementJDBCBase.substitute(string2, "", " "), "", "\t");
        return string3.compareToIgnoreCase(string4);
    }

    protected static String substitute(String string, String string2, String string3) {
        String string4 = "";
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string3, n2)) > -1) {
            string4 = string4 + string.substring(n2, n3) + string2;
            n2 = n3 + string3.length();
        }
        return string.indexOf(string3) == -1 ? string : string4 + string.substring(string.lastIndexOf(string3) + string3.length(), string.length());
    }

    public void setFetchSize(int n2) throws SQLException {
        this.preparedStmt.setFetchSize(n2);
    }

    public int getFetchSize() throws SQLException {
        return this.preparedStmt.getFetchSize();
    }

    private boolean checkAndSetInputIndicator(int n2, short s2, int n3) throws SQLException {
        if (s2 < 0 && s2 >= -7) {
            if (n3 != 1111) {
                this.preparedStmt.setNull(n2, n3);
                return true;
            }
        } else {
            if (s2 >= 0) {
                return false;
            }
            RuntimeErrors.raise_INVALID_INDICATOR(n2, s2);
        }
        return false;
    }
}

