/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.ParamManager;
import com.sybase.jdbc3.tds.MsgToken;
import com.sybase.jdbc3.tds.Tds;
import com.sybase.jdbc3.tds.TdsJdbcInputStream;
import com.sybase.jdbc3.tds.TdsProtocolContext;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosSessionContext {
    public static byte[] SYBASE_KERBEROS_OID_AS_DER = null;
    public static Oid JAVA_KERBEROS_OID = null;
    private GSSManager _gssMan = null;
    private GSSName _peerName = null;
    private GSSContext _gssCtx = null;
    private Tds _protocol = null;
    private SQLWarning _sqlw = null;
    private String _hostName = null;

    protected KerberosSessionContext(Tds tds) throws SQLException {
        this._protocol = tds;
        this.init();
    }

    private void init() throws SQLException {
        try {
            String string;
            Object object = this._protocol.getSybProperty().getObject(50);
            if (object != null) {
                if (object instanceof String) {
                    try {
                        this._gssMan = (GSSManager)Class.forName((String)object).newInstance();
                    }
                    catch (Exception exception) {
                        ErrorMessage.raiseError("JZ0GN", (String)object, exception.toString());
                    }
                } else {
                    try {
                        this._gssMan = (GSSManager)object;
                    }
                    catch (ClassCastException classCastException) {
                        ErrorMessage.raiseError("JZ0GC", object.getClass().getName());
                    }
                }
            } else {
                this._gssMan = GSSManager.getInstance();
            }
            if ((string = this._protocol.getSybProperty().getString(49)) == null) {
                string = this._hostName;
                SQLWarning sQLWarning = ErrorMessage.createWarning("010HN", this._hostName);
                this.addWarning(sQLWarning);
            }
            this._peerName = this._gssMan.createName(string, null);
            this._gssCtx = this._gssMan.createContext(this._peerName, JAVA_KERBEROS_OID, null, Integer.MAX_VALUE);
        }
        catch (GSSException gSSException) {
            ErrorMessage.raiseGSSError(gSSException);
        }
    }

    protected void beginHandshake(TdsProtocolContext tdsProtocolContext) throws IOException, SQLException {
        byte[] byArray = new byte[]{};
        this.sendOpaqueMessageToken(tdsProtocolContext, byArray);
    }

    protected void exchangeOpaqueTokens(TdsProtocolContext tdsProtocolContext) throws IOException, SQLException {
        MsgToken msgToken;
        int n = this._protocol.nextResult(tdsProtocolContext);
        if (n != 101) {
            ErrorMessage.raiseError("JZ0P4");
        }
        if ((msgToken = new MsgToken(tdsProtocolContext._in)).getMessageID() != 11) {
            ErrorMessage.raiseError("JZ0P4");
        }
        n = this._protocol.nextResult(tdsProtocolContext);
        if (tdsProtocolContext._lastTds != 236) {
            ErrorMessage.raiseError("JZ0P4");
        }
        if ((n = tdsProtocolContext._in.readUnsignedByte()) != 215) {
            ErrorMessage.raiseError("JZ0P4");
        }
        if (tdsProtocolContext._paramFmts.getColumnCount() != 5) {
            ErrorMessage.raiseError("JZ0P4");
        }
        TdsJdbcInputStream tdsJdbcInputStream = new TdsJdbcInputStream(tdsProtocolContext, this._protocol);
        for (int i = 0; i < 3; ++i) {
            tdsJdbcInputStream._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(i);
            tdsJdbcInputStream.open(false);
            tdsJdbcInputStream.resetInputStream(tdsProtocolContext._in);
            tdsJdbcInputStream.clear();
        }
        tdsJdbcInputStream._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(3);
        byte[] byArray = tdsJdbcInputStream.getBytes();
        tdsJdbcInputStream.clear();
        for (int i = 4; i < 5; ++i) {
            tdsJdbcInputStream._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(i);
            tdsJdbcInputStream.open(false);
            tdsJdbcInputStream.resetInputStream(tdsProtocolContext._in);
            tdsJdbcInputStream.clear();
        }
        tdsProtocolContext._lastResult = -1;
        n = this._protocol.nextResult(tdsProtocolContext);
        this._protocol._outStreamMgr.queueRequest(tdsProtocolContext);
        tdsProtocolContext.setState(2);
        tdsProtocolContext._haveDone = false;
        this.sendOpaqueMessageToken(tdsProtocolContext, byArray);
    }

    private void sendOpaqueMessageToken(TdsProtocolContext tdsProtocolContext, byte[] byArray) throws SQLException, IOException {
        MsgToken msgToken = new MsgToken(1, 11);
        ParamManager paramManager = new ParamManager(5, tdsProtocolContext);
        paramManager.setParam(1, 4, new Integer(50), 0);
        paramManager.setParam(2, 4, new Integer(1), 0);
        paramManager.setParam(3, -3, SYBASE_KERBEROS_OID_AS_DER, 0);
        if (byArray != null) {
            try {
                byArray = this._gssCtx.initSecContext(byArray, 0, byArray.length);
            }
            catch (GSSException gSSException) {
                ErrorMessage.raiseGSSError(gSSException);
            }
        }
        paramManager.setParam(4, -4, byArray, 0);
        paramManager.setParam(5, 4, new Integer(1), 0);
        msgToken.send(this._protocol._out);
        this._protocol.sendParamStream(paramManager, this._protocol._out);
        this._protocol._out.flush();
    }

    private void addWarning(SQLWarning sQLWarning) {
        if (this._sqlw == null) {
            this._sqlw = sQLWarning;
        } else {
            this._sqlw.setNextException(sQLWarning);
        }
    }

    protected void setHostName(String string) {
        this._hostName = string;
    }

    protected SQLWarning getWarnings() {
        return this._sqlw;
    }

    static {
        try {
            SYBASE_KERBEROS_OID_AS_DER = new Oid("1.3.6.1.4.1.897.4.6.6").getDER();
            JAVA_KERBEROS_OID = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }
}

