/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.sql.DmdbDateTime;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;

public class DmDateBinder
extends DmBinder {
    public DmDateBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 14;
        this.recPrec = 3;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Date x = (Date)this.pstmt.getParamObject(irow, icol);
        short dbtz = this.pstmt.connection.getTz();
        short ltz = this.pstmt.connection.getCnvtInfo().getTimeZone();
        String serverEncoding = this.pstmt.connection.getServerEncoding();
        byte[] ret = DmDateBinder.toDbBytes(x, this.destDType, this.destPrec, this.srcScale, serverEncoding, ltz, dbtz);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(Date x, int destDType, int destPrec, int srcScale, String serverEncoding, short ltz, short dbtz) throws SQLException {
        byte[] ret = null;
        DmdbDateTime dt = null;
        switch (destDType) {
            case 14: {
                dt = new DmdbDateTime(x.toString(), srcScale, 0);
                ret = Convertion.DateToByteArray(dt);
                break;
            }
            case 16: {
                Timestamp ts = new Timestamp(x.getTime());
                dt = new DmdbDateTime(ts.toString(), srcScale, 2);
                ret = Convertion.TimeStampToByteArray(dt, destDType, srcScale, dbtz, ltz);
                break;
            }
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 2: 
            case 19: {
                ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }
}

