/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.CnvtInfo;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbTime;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DmByteBinder
extends DmBinder {
    public DmByteBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 5;
        this.recPrec = 1;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        String serverEncoding = this.pstmt.connection.getServerEncoding();
        byte x = (Byte)this.pstmt.getParamObject(irow, icol);
        CnvtInfo cnvtInfo = this.pstmt.connection.getCnvtInfo();
        short dbTz = cnvtInfo.getDbTz();
        short ltz = cnvtInfo.getTimeZone();
        byte[] ret = DmByteBinder.toDbBytes(x, this.destDType, this.destPrec, this.destScale, serverEncoding, ltz, dbTz);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(byte x, int destDType, int destPrec, int destScale, String serverEncoding, short ltz, short dbTz) throws SQLException {
        byte[] ret = null;
        switch (destDType) {
            case 3: 
            case 13: {
                ret = Convertion.booleanToByteArray(x != 0);
                break;
            }
            case 5: {
                ret = Convertion.byteToByteArray(x);
                break;
            }
            case 6: {
                ret = Convertion.shortToByteArray(x);
                break;
            }
            case 7: {
                ret = Convertion.IntToByteArray(x);
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(x);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(x);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(x);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), destPrec, destScale);
                break;
            }
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 2: 
            case 19: {
                ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 16: {
                if ((long)x > 255611203200L) {
                    DBError.throwSQLException(-2512);
                }
                DmdbDateTime ts = new DmdbDateTime(new Timestamp((long)(x * 1000) - 2209017600000L).toString(), destScale, 2);
                ret = Convertion.TimeStampToByteArray(ts, destDType, destScale, dbTz, ltz);
                break;
            }
            case 15: {
                ret = Convertion.TimeToByteArray(new DmdbTime(String.valueOf(new Time(x * 1000)), destScale));
                break;
            }
            case 14: {
                if ((long)x > 2958463L) {
                    DBError.throwSQLException(-2512);
                }
                DmdbDateTime dt = new DmdbDateTime(new Date((long)(x * 24 * 60 * 60 * 1000) - 2209017600000L).toString(), destScale, 0);
                ret = Convertion.DateToByteArray(dt);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }
}

