/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core;

import com.edb.core.Field;
import com.edb.core.ProtocolConnection;
import com.edb.core.Query;
import com.edb.core.QueryExecutor;
import com.edb.core.ResultCursor;
import com.edb.core.ResultHandler;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

public class SetupQueryRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[][] run(ProtocolConnection protoConnection, String queryString, boolean wantResults) throws SQLException {
        QueryExecutor executor = protoConnection.getQueryExecutor();
        Query query = executor.createSimpleQuery(queryString);
        SimpleResultHandler handler = new SimpleResultHandler(protoConnection);
        int flags = 17;
        if (!wantResults) {
            flags |= 6;
        }
        try {
            executor.execute(query, null, handler, 0, 0, flags);
        }
        finally {
            query.close();
        }
        if (!wantResults) {
            return null;
        }
        List tuples = handler.getResults();
        if (tuples == null || tuples.size() != 1) {
            throw new PSQLException(GT.tr("An unexpected result was returned by a query."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return (byte[][])tuples.get(0);
    }

    private static class SimpleResultHandler
    implements ResultHandler {
        private SQLException error;
        private List tuples;
        private final ProtocolConnection protoConnection;

        SimpleResultHandler(ProtocolConnection protoConnection) {
            this.protoConnection = protoConnection;
        }

        List getResults() {
            return this.tuples;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
            this.tuples = tuples;
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
        }

        @Override
        public void handleWarning(SQLWarning warning) {
        }

        @Override
        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        @Override
        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }

        @Override
        public void notifyCommandStatus(String message) {
        }
    }
}

