/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess.ssl;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DbPureAccess;
import dm.jdbc.dbaccess.ssl.SSLHandshakeCompletedListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSLSocket {
    private volatile boolean handshakeCompleted = false;
    static /* synthetic */ Class class$0;

    public void convert(DbPureAccess dbPureAccess, Properties prop, boolean useSSLSocket) throws IOException, SQLException {
        SSLSocketFactory factory = null;
        try {
            Class<?> factoryClass = Class.forName("dm.jdbc.dbaccess.ssl.FullDuplexValidatingFactory");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.util.Properties");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor<?> ctor = factoryClass.getConstructor(classArray);
            factory = (SSLSocketFactory)ctor.newInstance(prop);
        }
        catch (Exception e) {
            DBError.throwSQLException(20002);
        }
        SSLSocket newConnection = (SSLSocket)factory.createSocket(dbPureAccess.getSocket(), dbPureAccess.getHostName(), dbPureAccess.getPortNumber(), true);
        newConnection.setSoTimeout(dbPureAccess.getSocket().getSoTimeout());
        String[] enableProtocols = new String[]{"TLSv1"};
        newConnection.setEnabledProtocols(enableProtocols);
        newConnection.addHandshakeCompletedListener(new SSLHandshakeCompletedListener(this));
        try {
            newConnection.startHandshake();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        this.sharkehand(dbPureAccess, newConnection, useSSLSocket);
    }

    private void sharkehand(DbPureAccess dbPureAccess, SSLSocket ssl, boolean useSSLSocket) throws IOException, SQLException {
        long timeIsOver = System.currentTimeMillis() + 5000L;
        while (!this.handshakeCompleted && timeIsOver - System.currentTimeMillis() > 0L) {
        }
        if (useSSLSocket) {
            if (this.handshakeCompleted) {
                dbPureAccess.changeSocket(ssl);
            } else {
                DBError.throwSQLException(6064);
            }
        }
    }

    public void setHandshakeCompleted(boolean completed) {
        this.handshakeCompleted = completed;
    }
}

