/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core;

import java.io.PrintWriter;
import java.sql.DriverManager;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Logger {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS ");
    private final FieldPosition dummyPosition = new FieldPosition(0);
    private final StringBuffer buffer = new StringBuffer();
    private final String connectionIDString;
    private static boolean needPrintInfo = true;
    private int level = 0;

    public Logger() {
        this.connectionIDString = "(driver) ";
    }

    public Logger(int connectionID) {
        this.connectionIDString = "(" + connectionID + ") ";
    }

    public void setLogLevel(int level) {
        this.level = level;
    }

    public int getLogLevel() {
        return this.level;
    }

    public boolean logDebug() {
        return this.level >= 2;
    }

    public boolean logInfo() {
        return this.level >= 1 && needPrintInfo;
    }

    public void debug(String str) {
        this.debug(str, null);
    }

    public void debug(String str, Throwable t) {
        if (this.logDebug()) {
            this.log(str, t);
        }
    }

    public void info(String str) {
        this.info(str, null);
    }

    public void info(String str, Throwable t) {
        if (this.logInfo()) {
            this.log(str, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String str, Throwable t) {
        PrintWriter writer = DriverManager.getLogWriter();
        if (writer == null) {
            return;
        }
        Logger logger = this;
        synchronized (logger) {
            this.buffer.setLength(0);
            this.dateFormat.format(new Date(), this.buffer, this.dummyPosition);
            this.buffer.append(this.connectionIDString);
            this.buffer.append(str);
            PrintWriter printWriter = writer;
            synchronized (printWriter) {
                writer.println(this.buffer.toString());
                if (t != null) {
                    t.printStackTrace(writer);
                }
            }
        }
    }

    public static void setNeedPrintInfo(boolean yes) {
        needPrintInfo = yes;
    }

    public static boolean needPrintInfo() {
        return needPrintInfo;
    }
}

