/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.SybCallableStatement;
import com.sybase.jdbc3.jdbc.SybUrlProvider;
import com.sybase.jdbc3.jdbc.SybXAConnection;
import com.sybase.jdbc3.jdbc.SybXADataSource;
import com.sybase.jdbc3.jdbc.SybXAResource11;
import com.sybase.jdbc3.jdbc.SybXid;
import com.sybase.jdbc3.utils.HexConverts;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SybXAResource
implements XAResource {
    private static final int MAX_SAFE_RM_NAME_LENGTH = 74;
    protected static final String RPC_PREFIX = "{?= call ";
    private static final String RPC_POSTFIX = " (?, ?, ?)}";
    private static final String COMMIT_RPC = "{?= call $commitSybDtmXact (?, ?, ?)}";
    private static final String ROLLBACK_RPC = "{?= call $rollbackSybDtmXact (?, ?, ?)}";
    private static final String FORGET_RPC = "{?= call $forgetSybDtmXact (?, ?, ?)}";
    private static final String PREPARE_RPC = "{?= call $prepareSybDtmXact (?, ?, ?)}";
    private static final String BEGIN_RPC = "{?= call $beginSybDtmXact (?, ?, ?, ?)}";
    private static final String END_RPC = "{?= call $endSybDtmXact (?, ?, ?)}";
    private static final String STATUS_RPC = "{?= call $statusSybDtmXact (?, ?, ?)}";
    private static final String ATTACH_RPC = "{?= call $attachSybDtmXact (?, ?, ?)}";
    private static final String DETACH_RPC = "{?= call $detachSybDtmXact (?, ?, ?)}";
    private static final String TRANSACTION_STATUS = "{?= call sp_transactions (?)}";
    private static final String ENCODING_MAP = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@#";
    private static final String ENCODED_XID_DELIMITER = "_";
    private static final String ENCODED_RM_NAME_DELIMITER = ":";
    protected int _transProtocolType = 196608;
    private int _timeout = 0;
    private final SybXADataSource _xaDataSource;
    protected final SybXAConnection _xaConn;
    protected final String _resourceManagerID;
    protected boolean _localTransactionOK = true;

    protected SybXAResource(String string, SybXAConnection sybXAConnection, SybXADataSource sybXADataSource, SybUrlProvider sybUrlProvider) {
        this._xaConn = sybXAConnection;
        this._xaDataSource = sybXADataSource;
        this._resourceManagerID = string;
    }

    public static SybXAResource createSybXAResource(int n, String string, SybXAConnection sybXAConnection, SybXADataSource sybXADataSource, SybUrlProvider sybUrlProvider) {
        SybXAResource sybXAResource = null;
        switch (n) {
            case 2: {
                sybXAResource = new SybXAResource(string, sybXAConnection, sybXADataSource, sybUrlProvider);
                break;
            }
            case 1: {
                sybXAResource = new SybXAResource11(string, sybXAConnection, sybXADataSource, sybUrlProvider);
                break;
            }
        }
        return sybXAResource;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        int n = 0;
        if (bl) {
            this.sendRPC(ATTACH_RPC, xid, 1, 2);
            this.sendRPC(END_RPC, xid, 2);
            n = 32;
        }
        this.sendRPC(COMMIT_RPC, xid, 100, n);
        this._localTransactionOK = true;
    }

    public void start(Xid xid, int n) throws XAException {
        this._localTransactionOK = false;
        if ((n & 0x8200000) == 0) {
            this.sendRPC(BEGIN_RPC, xid, 1, 16);
        } else {
            int n2 = this.sendRPC(ATTACH_RPC, xid, 1);
            if ((n & 0x8000000) != 0 && n2 != 3 || (n & 0x200000) != 0 && n2 == 101) {
                this.sendRPC(DETACH_RPC, xid, n2);
                throw new XAException(-6);
            }
        }
    }

    public void end(Xid xid, int n) throws XAException {
        int n2 = 2;
        if ((n & 0x2000000) != 0) {
            n2 = 3;
        } else if ((n & 0x20000000) != 0) {
            n2 = 101;
        }
        this.sendRPC(DETACH_RPC, xid, n2);
        this._localTransactionOK = true;
    }

    public void forget(Xid xid) throws XAException {
        this.sendRPC(FORGET_RPC, xid, 102);
        this._localTransactionOK = true;
    }

    public int prepare(Xid xid) throws XAException {
        this._localTransactionOK = false;
        this.sendRPC(ATTACH_RPC, xid, 1, 2);
        this.sendRPC(DETACH_RPC, xid, 2, 4);
        int n = this.sendRPC(PREPARE_RPC, xid, 7);
        return n == -256 ? 3 : 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xid[] recover(int n) throws XAException {
        Object object;
        Vector<SybXid> vector = new Vector<SybXid>();
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        if ((n & 0x1800000) == 0 && n != 0) {
            throw new XAException(-5);
        }
        boolean bl = false;
        if ((n & 0x1000000) != 0) {
            bl = true;
        }
        if (bl) {
            try {
                try {
                    callableStatement = this._xaConn.prepareCall(TRANSACTION_STATUS);
                    callableStatement.setString(2, "xa_recover");
                    resultSet = callableStatement.executeQuery();
                    while (resultSet.next()) {
                        object = resultSet.getString("xactname");
                        vector.add(this.dtmDecode((String)object));
                    }
                    Object var8_8 = null;
                }
                catch (SQLException sQLException) {
                    throw new XAException(-3);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (callableStatement == null) throw throwable;
                    callableStatement.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {}
            if (resultSet != null) {
                resultSet.close();
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        object = new Xid[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void rollback(Xid xid) throws XAException {
        this.sendRPC(ROLLBACK_RPC, xid, 101);
        this._localTransactionOK = true;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl = false;
        if (xAResource instanceof SybXAResource) {
            bl = this._resourceManagerID.equals(((SybXAResource)xAResource)._resourceManagerID);
        }
        return bl;
    }

    public int getTransactionTimeout() throws XAException {
        return this._timeout;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this._timeout = n;
        return false;
    }

    protected void close() {
    }

    protected boolean isLocalTransactionOK() {
        return this._localTransactionOK;
    }

    private int sendRPC(String string, Xid xid, int n) throws XAException {
        return this.sendRPC(string, xid, this._transProtocolType, n, 0);
    }

    private final int sendRPC(String string, Xid xid, int n, int n2) throws XAException {
        return this.sendRPC(string, xid, this._transProtocolType, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final int sendRPC(String var1_1, Xid var2_2, int var3_3, int var4_4, int var5_5) throws XAException {
        block23: {
            var6_6 = 0;
            var7_7 = null;
            var8_8 = null;
            var7_7 = (SybCallableStatement)this._xaConn.prepareCall(var1_1);
            var7_7.registerOutParameter(1, 4);
            var7_7.setString(2, this.dtmEncode(var2_2));
            var7_7.setParameterName(2, "@name");
            var7_7.setInt(3, var4_4);
            var7_7.setParameterName(3, "@status");
            var7_7.setInt(4, var5_5);
            var7_7.setParameterName(4, "@flags");
            if (var1_1 == "{?= call $beginSybDtmXact (?, ?, ?, ?)}") {
                var7_7.setInt(5, var3_3);
                var7_7.setParameterName(5, "@mode");
            }
            var7_7.execute();
            var6_6 = var7_7.getInt(1);
            var11_9 = null;
            try {
                if (var7_7 == null) ** GOTO lbl66
                var7_7.close();
            }
            catch (SQLException var12_12) {
                if (var8_8 == null) ** GOTO lbl66
                throw new XAException(-3);
            }
            finally {
                if (var8_8 != null) {
                    throw new XAException(-3);
                }
            }
            {
                catch (SQLException var9_18) {
                    var8_8 = var9_18;
                    var11_10 = null;
                    try {
                        if (var7_7 != null) {
                            var7_7.close();
                        }
                    }
                    catch (SQLException var12_13) {
                        if (var8_8 != null) {
                            throw new XAException(-3);
                        }
                        break block23;
                    }
                    finally {
                        if (var8_8 != null) {
                            throw new XAException(-3);
                        }
                    }
                }
            }
            catch (Throwable var10_19) {
                var11_11 = null;
                try {
                    if (var7_7 != null) {
                        var7_7.close();
                    }
                }
                catch (SQLException var12_14) {
                    if (var8_8 != null) {
                        throw new XAException(-3);
                    }
                }
                finally {
                    if (var8_8 != null) {
                        throw new XAException(-3);
                    }
                }
                throw var10_19;
            }
        }
        this.verifyReturnCode(var6_6);
        return var6_6;
    }

    private final void verifyReturnCode(int n) throws XAException {
        if (n < 0) {
            int n2 = 0;
            String string = null;
            boolean bl = true;
            switch (n) {
                case -1: {
                    n2 = -3;
                    break;
                }
                case -2: {
                    n2 = -4;
                    break;
                }
                case -3: {
                    n2 = -8;
                    break;
                }
                case -4: {
                    n2 = -7;
                    break;
                }
                case -5: {
                    n2 = -5;
                    break;
                }
                case -6: {
                    n2 = -6;
                    break;
                }
                case -128: {
                    n2 = -6;
                    break;
                }
                case -256: {
                    bl = false;
                    break;
                }
                default: {
                    string = "Unrecognized return code from server: " + n;
                }
            }
            if (bl) {
                if (string != null) {
                    throw new XAException(string);
                }
                throw new XAException(n2);
            }
        }
    }

    protected final String dtmEncode(Xid xid) throws XAException {
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        if (byArray.length > 64 || byArray2.length > 64) {
            throw new XAException(-4);
        }
        String string = "";
        string = string + HexConverts.hexConvert(xid.getFormatId(), 4) + ENCODED_XID_DELIMITER;
        string = string + SybXAResource.jjEncode(byArray) + ENCODED_XID_DELIMITER;
        string = string + SybXAResource.jjEncode(byArray2);
        return string;
    }

    protected final SybXid dtmDecode(String string) {
        int n = string.indexOf(ENCODED_XID_DELIMITER);
        int n2 = string.indexOf(ENCODED_XID_DELIMITER, n + 1);
        int n3 = string.indexOf(ENCODED_RM_NAME_DELIMITER, n2);
        SybXid sybXid = new SybXid(Integer.parseInt(string.substring(0, n), 16), SybXAResource.jjDecode(string.substring(n + 1, n2)), SybXAResource.jjDecode(string.substring(n2 + 1, string.length())));
        return sybXid;
    }

    private static final String jjEncode(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length * 4 / 3 + (byArray.length % 3 == 0 ? 0 : 1);
        char[] cArray = new char[n3];
        int n4 = 0;
        for (n2 = 0; n2 < byArray.length - 2; n2 += 3) {
            n = byArray[n2] >> 2 & 0x3F;
            cArray[n4++] = ENCODING_MAP.charAt(n);
            n = (byArray[n2] << 4 | byArray[n2 + 1] >> 4 & 0xF) & 0x3F;
            cArray[n4++] = ENCODING_MAP.charAt(n);
            n = (byArray[n2 + 1] << 2 | byArray[n2 + 2] >> 6 & 3) & 0x3F;
            cArray[n4++] = ENCODING_MAP.charAt(n);
            n = byArray[n2 + 2] & 0x3F;
            cArray[n4++] = ENCODING_MAP.charAt(n);
        }
        switch (byArray.length - n2) {
            case 2: {
                n = byArray[n2] >> 2 & 0x3F;
                cArray[n4++] = ENCODING_MAP.charAt(n);
                n = (byArray[n2] << 4 | byArray[n2 + 1] >> 4 & 0xF) & 0x3F;
                cArray[n4++] = ENCODING_MAP.charAt(n);
                n = byArray[n2 + 1] << 2 & 0x3F;
                cArray[n4] = ENCODING_MAP.charAt(n);
                break;
            }
            case 1: {
                n = byArray[n2] >> 2 & 0x3F;
                cArray[n4++] = ENCODING_MAP.charAt(n);
                n = byArray[n2] << 4 & 0x3F;
                cArray[n4] = ENCODING_MAP.charAt(n);
                break;
            }
            case 0: {
                --n4;
            }
        }
        return new String(cArray);
    }

    private static final byte[] jjDecode(String string) {
        int n;
        int n2;
        int n3;
        char[] cArray = string.toCharArray();
        int n4 = cArray.length * 3 / 4;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        for (n3 = 0; n3 < cArray.length - 3; n3 += 4) {
            n2 = ENCODING_MAP.indexOf(cArray[n3]) << 2;
            n = (ENCODING_MAP.indexOf(cArray[n3 + 1]) & 0x30) >> 4;
            byArray[n5++] = (byte)(n2 | n);
            n2 = (ENCODING_MAP.indexOf(cArray[n3 + 1]) & 0xF) << 4;
            n = (ENCODING_MAP.indexOf(cArray[n3 + 2]) & 0x3E) >> 2;
            byArray[n5++] = (byte)(n2 | n);
            n2 = (ENCODING_MAP.indexOf(cArray[n3 + 2]) & 3) << 6;
            n = ENCODING_MAP.indexOf(cArray[n3 + 3]) & 0x3F;
            byArray[n5++] = (byte)(n2 | n);
        }
        switch (cArray.length - n3) {
            case 3: {
                n2 = (ENCODING_MAP.indexOf(cArray[n3]) & 0x3F) << 2;
                n = (ENCODING_MAP.indexOf(cArray[n3 + 1]) & 0x30) >> 4;
                byArray[n5++] = (byte)(n2 | n);
                n2 = (ENCODING_MAP.indexOf(cArray[n3 + 1]) & 0xF) << 4;
                n = (ENCODING_MAP.indexOf(cArray[n3 + 2]) & 0x3E) >> 2;
                byArray[n5] = (byte)(n2 | n);
                break;
            }
            case 2: {
                n2 = (ENCODING_MAP.indexOf(cArray[n3]) & 0x3F) << 2;
                n = (ENCODING_MAP.indexOf(cArray[n3 + 1]) & 0x30) >> 4;
                byArray[n5] = (byte)(n2 | n);
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                --n5;
            }
        }
        return byArray;
    }
}

