/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rowset;

import dm.jdbc.dbaccess.DBError;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.Joinable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DmdbRowSetInner
implements Serializable,
Cloneable,
Joinable {
    private String m_url;
    private String m_dataSourceName;
    private String m_userName;
    private String m_password;
    private String m_command;
    private int m_transationIsolation;
    private boolean m_readOnly;
    private int m_maxFieldSize;
    private int m_maxRows;
    private int m_queryTimeout;
    private int m_rowSetType;
    private int m_resultConcurrencyType;
    private boolean m_process_escapes;
    private int m_direction;
    private int m_fetchSize;
    protected Vector<RowSetListener> m_listeners;
    protected RowSetEvent m_rowsetEvent;
    protected boolean m_showDeleted;
    private Vector<Integer> m_matchColIndexes;
    private Vector<String> m_matchColNames;
    private Map<String, Class<?>> m_typeMap = null;

    private void initializeProps() {
        this.m_process_escapes = true;
        this.m_showDeleted = false;
        this.m_rowSetType = 1004;
        this.m_direction = 1000;
        this.m_readOnly = false;
        this.m_maxFieldSize = 0;
        this.m_maxRows = 0;
        this.m_fetchSize = 0;
        this.m_queryTimeout = 0;
        this.m_url = "";
        this.m_userName = "";
        this.m_password = "";
        this.m_command = "";
        this.m_resultConcurrencyType = 1008;
        this.m_transationIsolation = 2;
    }

    protected DmdbRowSetInner() {
        this.initializeProps();
        this.m_listeners = new Vector();
        this.m_rowsetEvent = new RowSetEvent((RowSet)((Object)this));
        this.m_matchColIndexes = new Vector(10);
        this.m_matchColNames = new Vector(10);
    }

    protected final void notifyRowSetChanged() {
        int i = this.m_listeners.size();
        if (i > 0) {
            int j = 0;
            while (j < i) {
                this.m_listeners.elementAt(j).rowSetChanged(this.m_rowsetEvent);
                ++j;
            }
        }
    }

    protected final void notifyCursorMovement() {
        int i = this.m_listeners.size();
        if (i > 0) {
            int j = 0;
            while (j < i) {
                this.m_listeners.elementAt(j).cursorMoved(this.m_rowsetEvent);
                ++j;
            }
        }
    }

    protected final void notifyRowChanged() {
        int i = this.m_listeners.size();
        if (i > 0) {
            int j = 0;
            while (j < i) {
                this.m_listeners.elementAt(j).rowChanged(this.m_rowsetEvent);
                ++j;
            }
        }
    }

    protected final void notifyUpdateListeners() {
        int i = this.m_listeners.size();
        if (i > 0) {
            int j = 0;
            while (j < i) {
                this.m_listeners.elementAt(j).rowChanged(this.m_rowsetEvent);
                ++j;
            }
        }
    }

    private final void unsetColIndexIfSet(int columnIdx) throws SQLException {
        int size = this.m_matchColIndexes.size();
        int[] unsetInd = new int[size];
        int cnt = 0;
        if (columnIdx <= 0) {
            DBError.throwSQLException(20007);
        }
        int i = 0;
        while (i < size) {
            if (this.m_matchColIndexes.get(i).equals(columnIdx)) {
                unsetInd[cnt] = i;
                ++cnt;
            }
            ++i;
        }
        if (cnt == 0) {
            DBError.throwSQLException(20014);
        }
        i = cnt - 1;
        while (i >= 0) {
            this.m_matchColIndexes.remove(unsetInd[i]);
            --i;
        }
    }

    private final void unsetColNameIfSet(String columnName) throws SQLException {
        int size = this.m_matchColNames.size();
        int[] unsetInd = new int[size];
        int cnt = 0;
        if (columnName == null || columnName == "") {
            DBError.throwSQLException(20009);
        }
        int i = 0;
        while (i < size) {
            if (this.m_matchColNames.get(i).equalsIgnoreCase(columnName)) {
                unsetInd[i] = i;
                ++cnt;
            }
            ++i;
        }
        if (cnt == 0) {
            DBError.throwSQLException(20015);
        }
        i = cnt - 1;
        while (i >= 0) {
            this.m_matchColNames.remove(unsetInd[i]);
            --i;
        }
    }

    @Override
    public void setMatchColumn(int columnIdx) throws SQLException {
        if (columnIdx <= 0) {
            DBError.throwSQLException(20007);
        }
        this.m_matchColIndexes.clear();
        this.m_matchColNames.clear();
        this.m_matchColIndexes.add(columnIdx);
    }

    @Override
    public void setMatchColumn(int[] columnIdxes) throws SQLException {
        if (columnIdxes == null) {
            DBError.throwSQLException(20008);
        }
        this.m_matchColIndexes.clear();
        this.m_matchColNames.clear();
        int i = 0;
        while (i < columnIdxes.length) {
            if (columnIdxes[i] <= 0) {
                DBError.throwSQLException(20007);
            }
            this.m_matchColIndexes.add(columnIdxes[i]);
            ++i;
        }
    }

    @Override
    public void setMatchColumn(String columnName) throws SQLException {
        if (columnName == null || columnName == "") {
            DBError.throwSQLException(20009);
        }
        this.m_matchColIndexes.clear();
        this.m_matchColNames.clear();
        this.m_matchColNames.add(columnName);
    }

    @Override
    public void setMatchColumn(String[] columnNames) throws SQLException {
        if (columnNames == null) {
            DBError.throwSQLException(20010);
        }
        this.m_matchColIndexes.clear();
        this.m_matchColNames.clear();
        int i = 0;
        while (i < columnNames.length) {
            if (columnNames[i] == null || columnNames[i] == "") {
                DBError.throwSQLException(20009);
            }
            this.m_matchColNames.add(columnNames[i]);
            ++i;
        }
    }

    public abstract int findColumn(String var1) throws SQLException;

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        if (this.m_matchColIndexes.isEmpty() && this.m_matchColNames.isEmpty()) {
            DBError.throwSQLException(20011);
        }
        int[] ret = null;
        int size = 0;
        if (!this.m_matchColIndexes.isEmpty()) {
            size = this.m_matchColIndexes.size();
            ret = new int[size];
            int i = 0;
            while (i < size) {
                ret[i] = this.m_matchColIndexes.get(i);
                ++i;
            }
        } else {
            size = this.m_matchColNames.size();
            ret = new int[size];
            int i = 0;
            while (i < size) {
                ret[i] = this.findColumn(this.m_matchColNames.get(i));
                ++i;
            }
        }
        return ret;
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        if (this.m_matchColNames.isEmpty()) {
            DBError.throwSQLException(20012);
        }
        String[] ret = null;
        int size = this.m_matchColNames.size();
        ret = new String[size];
        int i = 0;
        while (i < size) {
            ret[i] = this.m_matchColNames.get(i);
            ++i;
        }
        return ret;
    }

    @Override
    public void unsetMatchColumn(int columnIdx) throws SQLException {
        if (this.m_matchColIndexes.isEmpty()) {
            DBError.throwSQLException(20013);
        }
        this.unsetColIndexIfSet(columnIdx);
    }

    @Override
    public void unsetMatchColumn(int[] columnIdxes) throws SQLException {
        if (this.m_matchColIndexes.isEmpty()) {
            DBError.throwSQLException(20013);
        }
        if (columnIdxes == null) {
            DBError.throwSQLException(20008);
        }
        int i = 0;
        while (i < columnIdxes.length) {
            this.unsetColIndexIfSet(columnIdxes[i]);
            ++i;
        }
    }

    @Override
    public void unsetMatchColumn(String columnName) throws SQLException {
        if (this.m_matchColNames.isEmpty()) {
            DBError.throwSQLException(20012);
        }
        this.unsetColNameIfSet(columnName);
    }

    @Override
    public void unsetMatchColumn(String[] columnName) throws SQLException {
        if (this.m_matchColNames.isEmpty()) {
            DBError.throwSQLException(20012);
        }
        if (columnName == null) {
            DBError.throwSQLException(20010);
        }
        int i = 0;
        while (i < columnName.length) {
            this.unsetColNameIfSet(columnName[i]);
            ++i;
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.m_direction = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.m_direction;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.m_fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    public int getType() throws SQLException {
        return this.m_rowSetType;
    }

    public int getConcurrency() throws SQLException {
        return this.m_resultConcurrencyType;
    }

    public String getUrl() throws SQLException {
        return this.m_url;
    }

    public void setUrl(String url) throws SQLException {
        this.m_url = url;
    }

    public String getDataSourceName() {
        return this.m_dataSourceName;
    }

    public void setDataSourceName(String name) throws SQLException {
        this.m_dataSourceName = name;
    }

    public String getUsername() {
        return this.m_userName;
    }

    public void setUsername(String name) throws SQLException {
        this.m_userName = name;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) throws SQLException {
        this.m_password = password;
    }

    public int getTransactionIsolation() {
        return this.m_transationIsolation;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.m_transationIsolation = level;
    }

    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.m_typeMap;
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.m_typeMap = map;
    }

    public String getCommand() {
        return this.m_command;
    }

    public void setCommand(String cmd) throws SQLException {
        this.m_command = cmd;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean value) throws SQLException {
        this.m_readOnly = value;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.m_maxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.m_maxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        return this.m_maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.m_maxRows = max;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.m_process_escapes;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.m_process_escapes = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.m_queryTimeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.m_queryTimeout = seconds;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.m_showDeleted;
    }

    public void setShowDeleted(boolean b) throws SQLException {
        this.m_showDeleted = b;
    }

    public void setType(int type) throws SQLException {
        this.m_rowSetType = type;
    }

    public void setConcurrency(int concurrency) throws SQLException {
        this.m_resultConcurrencyType = concurrency;
    }

    public void addRowSetListener(RowSetListener listener) {
        int i = 0;
        while (i < this.m_listeners.size()) {
            if (this.m_listeners.get(i).equals(listener)) {
                return;
            }
            ++i;
        }
        this.m_listeners.add(listener);
    }

    public void removeRowSetListener(RowSetListener listener) {
        int i = 0;
        while (i < this.m_listeners.size()) {
            if (this.m_listeners.get(i).equals(listener)) {
                this.m_listeners.remove(i);
            }
            ++i;
        }
    }
}

