/*
 * Decompiled with CFR 0.152.
 */
package com.edb.ds.common;

import com.edb.Driver;
import com.edb.ds.common.PGObjectFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public abstract class BaseDataSource
implements Referenceable {
    private transient PrintWriter logger;
    private String serverName = "localhost";
    private String databaseName = "";
    private String user;
    private String password;
    private int portNumber = 0;
    private int prepareThreshold = 5;
    private int unknownLength = Integer.MAX_VALUE;
    private boolean binaryTransfer = true;
    private String binaryTransferEnable;
    private String binaryTransferDisable;
    private int loginTimeout = 0;
    private int socketTimeout = 0;
    private int receiveBufferSize = -1;
    private int sendBufferSize = -1;
    private boolean ssl = false;
    private String sslfactory = null;
    private boolean tcpKeepAlive = false;
    private String compatible = null;
    private int logLevel = 0;
    private int protocolVersion = 0;
    private String applicationName;
    private String stringType = null;
    private boolean logLevelSet = false;
    private boolean disableColumnSanitiser = false;
    private boolean oracleCase = false;

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        try {
            Connection con = DriverManager.getConnection(this.getUrl(), user, password);
            if (this.logger != null) {
                this.logger.println("Created a non-pooled connection for " + user + " at " + this.getUrl());
            }
            return con;
        }
        catch (SQLException e) {
            if (this.logger != null) {
                this.logger.println("Failed to create a non-pooled connection for " + user + " at " + this.getUrl() + ": " + e);
            }
            throw e;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int i) throws SQLException {
        this.loginTimeout = i;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logger = printWriter;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName == null || serverName.equals("") ? "localhost" : serverName;
    }

    public String getCompatible() {
        return this.compatible;
    }

    public void setCompatible(String compatible) {
        this.compatible = compatible;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
        this.logLevelSet = true;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public abstract String getDescription();

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setPrepareThreshold(int count) {
        this.prepareThreshold = count;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int nbytes) {
        this.receiveBufferSize = nbytes;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int nbytes) {
        this.sendBufferSize = nbytes;
    }

    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    public void setUnknownLength(int unknownLength) {
        this.unknownLength = unknownLength;
    }

    public int getUnknownLength() {
        return this.unknownLength;
    }

    public void setSocketTimeout(int seconds) {
        this.socketTimeout = seconds;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSsl(boolean enabled) {
        this.ssl = enabled;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public void setSslfactory(String classname) {
        this.sslfactory = classname;
    }

    public String getSslfactory() {
        return this.sslfactory;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setTcpKeepAlive(boolean enabled) {
        this.tcpKeepAlive = enabled;
    }

    public boolean getTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public void setBinaryTransfer(boolean enabled) {
        this.binaryTransfer = enabled;
    }

    public boolean getBinaryTransfer() {
        return this.binaryTransfer;
    }

    public void setBinaryTransferEnable(String oidList) {
        this.binaryTransferEnable = oidList;
    }

    public String getBinaryTransferEnable() {
        return this.binaryTransferEnable;
    }

    public void setBinaryTransferDisable(String oidList) {
        this.binaryTransferDisable = oidList;
    }

    public String getBinaryTransferDisable() {
        return this.binaryTransferDisable;
    }

    public String getStringType() {
        return this.stringType;
    }

    public void setStringType(String stringType) {
        this.stringType = stringType;
    }

    public boolean isColumnSanitiserDisabled() {
        return this.disableColumnSanitiser;
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        this.disableColumnSanitiser = disableColumnSanitiser;
    }

    public boolean getOracleCase() {
        return this.oracleCase;
    }

    public void setOracleCase(boolean oracleCase) {
        this.oracleCase = oracleCase;
    }

    public String getUrl() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("jdbc:edb://");
        sb.append(this.serverName);
        if (this.portNumber != 0) {
            sb.append(":").append(this.portNumber);
        }
        sb.append("/").append(this.databaseName);
        sb.append("?loginTimeout=").append(this.loginTimeout);
        sb.append("&socketTimeout=").append(this.socketTimeout);
        sb.append("&prepareThreshold=").append(this.prepareThreshold);
        sb.append("&unknownLength=").append(this.unknownLength);
        if (this.logLevelSet) {
            sb.append("&loglevel=").append(this.logLevel);
        }
        sb.append("&oracleCase=").append(this.oracleCase);
        if (this.protocolVersion != 0) {
            sb.append("&protocolVersion=").append(this.protocolVersion);
        }
        if (this.ssl) {
            sb.append("&ssl=true");
            if (this.sslfactory != null) {
                sb.append("&sslfactory=").append(this.sslfactory);
            }
        }
        if (this.receiveBufferSize != -1) {
            sb.append("&receiveBufferSize=").append(this.receiveBufferSize);
        }
        if (this.sendBufferSize != -1) {
            sb.append("&sendBufferSize=").append(this.sendBufferSize);
        }
        sb.append("&tcpKeepAlive=").append(this.tcpKeepAlive);
        if (this.compatible != null) {
            sb.append("&compatible=" + this.compatible);
        }
        if (this.applicationName != null) {
            sb.append("&ApplicationName=");
            sb.append(this.applicationName);
        }
        sb.append("&binaryTransfer=").append(this.binaryTransfer);
        if (this.stringType != null) {
            sb.append("&stringtype");
            sb.append(this.stringType);
        }
        if (this.binaryTransferEnable != null) {
            sb.append("&binaryTransferEnable=").append(this.binaryTransferEnable);
        }
        if (this.binaryTransferDisable != null) {
            sb.append("&binaryTransferDisable=").append(this.binaryTransferDisable);
        }
        sb.append("&disableColumnSanitiser=").append(this.disableColumnSanitiser);
        return sb.toString();
    }

    public void setUrl(String url) throws SQLException {
        Properties p = Driver.parseURL(url, null);
        this.serverName = p.getProperty("PGHOST", "localhost");
        this.portNumber = Integer.parseInt(p.getProperty("PGPORT", "0"));
        this.databaseName = p.getProperty("PGDBNAME");
        this.loginTimeout = Integer.parseInt(p.getProperty("loginTimeout", "0"));
        this.socketTimeout = Integer.parseInt(p.getProperty("socketTimeout", "0"));
        this.prepareThreshold = Integer.parseInt(p.getProperty("prepareThreshold", "5"));
        this.unknownLength = Integer.parseInt(p.getProperty("unknownLength", "0"));
        this.logLevel = Integer.parseInt(p.getProperty("loglevel", "0"));
        this.protocolVersion = Integer.parseInt(p.getProperty("protocolVersion", "0"));
        this.ssl = Boolean.valueOf(p.getProperty("ssl"));
        this.sslfactory = p.getProperty("sslfactory");
        this.receiveBufferSize = Integer.parseInt(p.getProperty("receiveBufferSize", "-1"));
        this.sendBufferSize = Integer.parseInt(p.getProperty("sendBufferSize", "-1"));
        this.tcpKeepAlive = Boolean.valueOf(p.getProperty("tcpKeepAlive"));
        this.compatible = p.getProperty("compatible");
        this.applicationName = p.getProperty("ApplicationName");
        this.stringType = p.getProperty("stringtype");
        this.binaryTransfer = Boolean.valueOf(p.getProperty("binaryTransfer"));
        this.disableColumnSanitiser = Boolean.valueOf(p.getProperty("disableColumnSanitiser"));
    }

    protected Reference createReference() {
        return new Reference(this.getClass().getName(), PGObjectFactory.class.getName(), null);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = this.createReference();
        ref.add(new StringRefAddr("serverName", this.serverName));
        if (this.portNumber != 0) {
            ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        ref.add(new StringRefAddr("databaseName", this.databaseName));
        if (this.user != null) {
            ref.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            ref.add(new StringRefAddr("password", this.password));
        }
        ref.add(new StringRefAddr("prepareThreshold", Integer.toString(this.prepareThreshold)));
        ref.add(new StringRefAddr("unknownLength", Integer.toString(this.unknownLength)));
        ref.add(new StringRefAddr("binaryTransfer", Boolean.toString(this.binaryTransfer)));
        if (this.binaryTransferEnable != null) {
            ref.add(new StringRefAddr("binaryTransferEnable", this.binaryTransferEnable));
        }
        if (this.binaryTransferDisable != null) {
            ref.add(new StringRefAddr("binaryTransferDisable", this.binaryTransferDisable));
        }
        ref.add(new StringRefAddr("oracleCase", Boolean.toString(this.oracleCase)));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        ref.add(new StringRefAddr("socketTimeout", Integer.toString(this.socketTimeout)));
        ref.add(new StringRefAddr("ssl", Boolean.toString(this.ssl)));
        if (this.sslfactory != null) {
            ref.add(new StringRefAddr("sslfactory", this.sslfactory));
        }
        ref.add(new StringRefAddr("receiveBufferSize", Integer.toString(this.receiveBufferSize)));
        ref.add(new StringRefAddr("sendBufferSize", Integer.toString(this.sendBufferSize)));
        ref.add(new StringRefAddr("tcpKeepAlive", Boolean.toString(this.tcpKeepAlive)));
        if (this.compatible != null) {
            ref.add(new StringRefAddr("compatible", this.compatible));
        }
        if (this.stringType != null) {
            ref.add(new StringRefAddr("stringtype", this.stringType));
        }
        if (this.logLevelSet) {
            ref.add(new StringRefAddr("logLevel", Integer.toString(this.logLevel)));
        }
        ref.add(new StringRefAddr("protocolVersion", Integer.toString(this.protocolVersion)));
        if (this.applicationName != null) {
            ref.add(new StringRefAddr("ApplicationName", this.applicationName));
        }
        ref.add(new StringRefAddr("disableColumnSanitiser", Boolean.toString(this.disableColumnSanitiser)));
        ref.add(new StringRefAddr("oracleCase", Boolean.toString(this.oracleCase)));
        return ref;
    }

    protected void writeBaseObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.serverName);
        out.writeObject(this.databaseName);
        out.writeObject(this.user);
        out.writeObject(this.password);
        out.writeInt(this.portNumber);
        out.writeInt(this.prepareThreshold);
        out.writeInt(this.unknownLength);
        out.writeInt(this.loginTimeout);
        out.writeInt(this.socketTimeout);
        out.writeBoolean(this.ssl);
        out.writeObject(this.sslfactory);
        out.writeInt(this.receiveBufferSize);
        out.writeInt(this.sendBufferSize);
        out.writeBoolean(this.tcpKeepAlive);
        out.writeObject(this.compatible);
        out.writeObject(this.stringType);
        out.writeInt(this.logLevel);
        out.writeInt(this.protocolVersion);
        out.writeObject(this.applicationName);
        out.writeBoolean(this.binaryTransfer);
        out.writeObject(this.binaryTransferEnable);
        out.writeObject(this.binaryTransferDisable);
        out.writeBoolean(this.logLevelSet);
        out.writeBoolean(this.disableColumnSanitiser);
        out.writeObject(this.oracleCase);
    }

    protected void readBaseObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.serverName = (String)in.readObject();
        this.databaseName = (String)in.readObject();
        this.user = (String)in.readObject();
        this.password = (String)in.readObject();
        this.portNumber = in.readInt();
        this.prepareThreshold = in.readInt();
        this.unknownLength = in.readInt();
        this.loginTimeout = in.readInt();
        this.socketTimeout = in.readInt();
        this.ssl = in.readBoolean();
        this.sslfactory = (String)in.readObject();
        this.receiveBufferSize = in.readInt();
        this.sendBufferSize = in.readInt();
        this.tcpKeepAlive = in.readBoolean();
        this.compatible = (String)in.readObject();
        this.stringType = (String)in.readObject();
        this.logLevel = in.readInt();
        this.protocolVersion = in.readInt();
        this.applicationName = (String)in.readObject();
        this.binaryTransfer = in.readBoolean();
        this.binaryTransferEnable = (String)in.readObject();
        this.binaryTransferDisable = (String)in.readObject();
        this.logLevelSet = in.readBoolean();
        this.disableColumnSanitiser = in.readBoolean();
        this.oracleCase = (Boolean)in.readObject();
    }

    public void initializeFrom(BaseDataSource source) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        source.writeBaseObject(oos);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        this.readBaseObject(ois);
    }

    static {
        try {
            Class.forName("com.edb.Driver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("EnterpriseDB DataSource unable to load EnterpriseDB JDBC Driver");
        }
    }
}

